/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.List;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class Transpose
extends SimpleBatchFilter
implements UnsupervisedFilter,
WeightedAttributesHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = 213999899640387499L;

    @Override
    public String globalInfo() {
        return "Transposes the data: instances become attributes and attributes become instances. If the first attribute in the original data is a nominal or string identifier attribute, this identifier attribute will be used to create attribute names in the transposed data. All attributes other than the identifier attribute must be numeric. The attribute names in the original data are used to create an identifier attribute of type string in the transposed data.\n\nThis filter can only process one batch of data, e.g., it cannot be used in the the FilteredClassifier.\n\nThis filter can only be applied when no class attribute has been set.\n\nDate values will be turned into simple numeric values.\n\n";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        ArrayList<Attribute> newAtts = new ArrayList<Attribute>(inputFormat.numInstances());
        newAtts.add(new Attribute("Identifier", (List<String>)null));
        for (int i = 0; i < inputFormat.numInstances(); ++i) {
            if (inputFormat.attribute(0).isNominal() || inputFormat.attribute(0).isString()) {
                newAtts.add(new Attribute(inputFormat.instance(i).stringValue(0)));
            } else {
                newAtts.add(new Attribute("" + (i + 1)));
            }
            newAtts.get(i).setWeight(inputFormat.instance(i).weight());
        }
        return new Instances(inputFormat.relationName(), newAtts, inputFormat.numAttributes());
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        if (this.isFirstBatchDone()) {
            throw new Exception("The Transpose filter can only process one batch of instances.");
        }
        this.setOutputFormat(this.determineOutputFormat(instances));
        int offset = instances.attribute(0).isNominal() || instances.attribute(0).isString() ? 1 : 0;
        double[][] newData = new double[instances.numAttributes() - offset][instances.numInstances() + 1];
        for (int i = 0; i < instances.numInstances(); ++i) {
            for (int j = offset; j < instances.numAttributes(); ++j) {
                newData[j - offset][0] = this.getOutputFormat().attribute(0).addStringValue(instances.attribute(j).name());
                if (!instances.attribute(j).isNumeric()) {
                    throw new Exception("Only numeric attributes can be transposed: " + instances.attribute(j).name() + " is not numeric.");
                }
                newData[j - offset][i + 1] = instances.instance(i).value(j);
            }
        }
        Instances result = this.getOutputFormat();
        for (int i = 0; i < newData.length; ++i) {
            result.add(new DenseInstance(instances.attribute(i + offset).weight(), newData[i]));
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10215 $");
    }

    public static void main(String[] args) {
        Transpose.runFilter(new Transpose(), args);
    }
}

