/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.adapters.resin;

import com.caucho.http.security.AbstractAuthenticator;
import java.security.Principal;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.adapters.PrincipalAcegiUserToken;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ResinAcegiAuthenticator
extends AbstractAuthenticator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$adapters$resin$ResinAcegiAuthenticator == null ? (class$org$acegisecurity$adapters$resin$ResinAcegiAuthenticator = ResinAcegiAuthenticator.class$("org.acegisecurity.adapters.resin.ResinAcegiAuthenticator")) : class$org$acegisecurity$adapters$resin$ResinAcegiAuthenticator));
    private AuthenticationManager authenticationManager;
    private String appContextLocation;
    private String key;
    static /* synthetic */ Class class$org$acegisecurity$adapters$resin$ResinAcegiAuthenticator;
    static /* synthetic */ Class class$org$acegisecurity$AuthenticationManager;

    public String getAppContextLocation() {
        return this.appContextLocation;
    }

    public String getKey() {
        return this.key;
    }

    public void init() throws ServletException {
        super.init();
        if (this.appContextLocation == null || "".equals(this.appContextLocation)) {
            throw new ServletException("appContextLocation must be defined");
        }
        if (this.key == null || "".equals(this.key)) {
            throw new ServletException("key must be defined");
        }
        if (Thread.currentThread().getContextClassLoader().getResource(this.appContextLocation) == null) {
            throw new ServletException("Cannot locate " + this.appContextLocation);
        }
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(this.appContextLocation);
        Map beans = ctx.getBeansOfType(class$org$acegisecurity$AuthenticationManager == null ? (class$org$acegisecurity$AuthenticationManager = ResinAcegiAuthenticator.class$("org.acegisecurity.AuthenticationManager")) : class$org$acegisecurity$AuthenticationManager, true, true);
        if (beans.size() == 0) {
            throw new ServletException("Bean context must contain at least one bean of type AuthenticationManager");
        }
        String beanName = (String)beans.keySet().iterator().next();
        this.authenticationManager = (AuthenticationManager)beans.get(beanName);
        logger.info((Object)"ResinAcegiAuthenticator Started");
    }

    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal principal, String role) {
        if (!(principal instanceof PrincipalAcegiUserToken)) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Expected passed principal to be of type PrincipalAcegiUserToken");
            }
            return false;
        }
        PrincipalAcegiUserToken test = (PrincipalAcegiUserToken)principal;
        return test.isUserInRole(role);
    }

    protected Principal loginImpl(String username, String credentials) {
        if (username == null) {
            return null;
        }
        if (credentials == null) {
            credentials = "";
        }
        UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken((Object)username, (Object)credentials);
        Authentication response = null;
        try {
            response = this.authenticationManager.authenticate((Authentication)request);
        }
        catch (AuthenticationException failed) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication request for user: " + username + " failed: " + failed.toString()));
            }
            return null;
        }
        return new PrincipalAcegiUserToken(this.key, response.getPrincipal().toString(), response.getCredentials().toString(), response.getAuthorities(), response.getPrincipal());
    }

    protected Principal loginImpl(HttpServletRequest request, HttpServletResponse response, ServletContext application, String userName, String password) throws ServletException {
        return this.loginImpl(userName, password);
    }

    public void setAppContextLocation(String appContextLocation) {
        this.appContextLocation = appContextLocation;
    }

    public void setKey(String key) {
        this.key = key;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

