/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.repository.editor;

import java.util.List;
import org.activiti.app.domain.editor.Model;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ModelRepository
extends JpaRepository<Model, String> {
    @Query(value="from Model as model where model.createdBy = :user and model.modelType = :modelType")
    public List<Model> findModelsCreatedBy(@Param(value="user") String var1, @Param(value="modelType") Integer var2, Sort var3);

    @Query(value="from Model as model where model.createdBy = :user and (lower(model.name) like :filter or lower(model.description) like :filter) and model.modelType = :modelType")
    public List<Model> findModelsCreatedBy(@Param(value="user") String var1, @Param(value="modelType") Integer var2, @Param(value="filter") String var3, Sort var4);

    @Query(value="from Model as model where model.key = :key and model.modelType = :modelType")
    public List<Model> findModelsByKeyAndType(@Param(value="key") String var1, @Param(value="modelType") Integer var2);

    @Query(value="from Model as model where (lower(model.name) like :filter or lower(model.description) like :filter) and model.modelType = :modelType")
    public List<Model> findModelsByModelType(@Param(value="modelType") Integer var1, @Param(value="filter") String var2);

    @Query(value="from Model as model where model.modelType = :modelType")
    public List<Model> findModelsByModelType(@Param(value="modelType") Integer var1);

    @Query(value="select count(m.id) from Model m where m.createdBy = :user and m.modelType = :modelType")
    public Long countByModelTypeAndUser(@Param(value="modelType") int var1, @Param(value="user") String var2);

    @Query(value="select m from ModelRelation mr inner join mr.model m where mr.parentModelId = :parentModelId")
    public List<Model> findModelsByParentModelId(@Param(value="parentModelId") String var1);

    @Query(value="select m from ModelRelation mr inner join mr.model m where mr.parentModelId = :parentModelId and m.modelType = :modelType")
    public List<Model> findModelsByParentModelIdAndType(@Param(value="parentModelId") String var1, @Param(value="modelType") Integer var2);

    @Query(value="select m.id, m.name, m.modelType from ModelRelation mr inner join mr.parentModel m where mr.modelId = :modelId")
    public List<Model> findModelsByChildModelId(@Param(value="modelId") String var1);

    @Query(value="select model.key from Model as model where model.id = :modelId and model.createdBy = :user")
    public String appDefinitionIdByModelAndUser(@Param(value="modelId") String var1, @Param(value="user") String var2);
}

