/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.editor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.app.model.runtime.CompleteFormRepresentation;
import org.activiti.app.model.runtime.ProcessInstanceVariableRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.app.service.exception.NotPermittedException;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.identity.User;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.form.api.FormRepositoryService;
import org.activiti.form.api.FormService;
import org.activiti.form.model.FormDefinition;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivitiTaskFormService {
    private static final Logger logger = LoggerFactory.getLogger(ActivitiTaskFormService.class);
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected FormService formService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected ObjectMapper objectMapper;

    public FormDefinition getTaskForm(String taskId) {
        HistoricTaskInstance task = this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), taskId);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (task.getProcessInstanceId() != null) {
            List variableInstances = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(task.getProcessInstanceId()).list();
            for (HistoricVariableInstance historicVariableInstance : variableInstances) {
                variables.put(historicVariableInstance.getVariableName(), historicVariableInstance.getValue());
            }
        }
        String parentDeploymentId = null;
        if (StringUtils.isNotEmpty((CharSequence)task.getProcessDefinitionId())) {
            try {
                ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(task.getProcessDefinitionId());
                parentDeploymentId = processDefinition.getDeploymentId();
            }
            catch (ActivitiException e) {
                logger.error("Error getting process definition " + task.getProcessDefinitionId(), (Throwable)e);
            }
        }
        Object formDefinition = null;
        formDefinition = task.getEndTime() != null ? this.formService.getCompletedTaskFormDefinitionByKeyAndParentDeploymentId(task.getFormKey(), parentDeploymentId, taskId, task.getProcessInstanceId(), variables, task.getTenantId()) : this.formService.getTaskFormDefinitionByKeyAndParentDeploymentId(task.getFormKey(), parentDeploymentId, task.getProcessInstanceId(), variables, task.getTenantId());
        if (formDefinition == null) {
            throw new NotFoundException("Form definition for task " + task.getTaskDefinitionKey() + " cannot be found for form key " + task.getFormKey());
        }
        return formDefinition;
    }

    public void completeTaskForm(String taskId, CompleteFormRepresentation completeTaskFormRepresentation) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task not found with id: " + taskId);
        }
        FormDefinition formDefinition = this.formRepositoryService.getFormDefinitionById(completeTaskFormRepresentation.getFormId());
        User currentUser = SecurityUtils.getCurrentUserObject();
        if (!this.permissionService.isTaskOwnerOrAssignee(currentUser, taskId) && !this.permissionService.validateIfUserIsInitiatorAndCanCompleteTask(currentUser, task)) {
            throw new NotPermittedException();
        }
        Map variables = this.formService.getVariablesFromFormSubmission(formDefinition, completeTaskFormRepresentation.getValues(), completeTaskFormRepresentation.getOutcome());
        this.formService.storeSubmittedForm(variables, formDefinition, task.getId(), task.getProcessInstanceId());
        this.taskService.complete(taskId, variables);
    }

    public List<ProcessInstanceVariableRepresentation> getProcessInstanceVariables(String taskId) {
        HistoricTaskInstance task = this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), taskId);
        List historicVariables = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(task.getProcessInstanceId()).list();
        HashMap<String, ProcessInstanceVariableRepresentation> processInstanceVariables = new HashMap<String, ProcessInstanceVariableRepresentation>();
        for (HistoricVariableInstance historicVariableInstance : historicVariables) {
            ProcessInstanceVariableRepresentation processInstanceVariableRepresentation = new ProcessInstanceVariableRepresentation(historicVariableInstance.getVariableName(), historicVariableInstance.getVariableTypeName(), historicVariableInstance.getValue());
            processInstanceVariables.put(historicVariableInstance.getId(), processInstanceVariableRepresentation);
        }
        ArrayList<ProcessInstanceVariableRepresentation> processInstanceVariableRepresenations = new ArrayList<ProcessInstanceVariableRepresentation>(processInstanceVariables.values());
        return processInstanceVariableRepresenations;
    }
}

