/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.editor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.activiti.app.domain.editor.AbstractModel;
import org.activiti.app.domain.editor.AppDefinition;
import org.activiti.app.domain.editor.AppModelDefinition;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.model.editor.AppDefinitionRepresentation;
import org.activiti.app.repository.editor.ModelRepository;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.ModelService;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppDefinitionExportService {
    private static final Logger logger = LoggerFactory.getLogger(AppDefinitionExportService.class);
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ObjectMapper objectMapper;
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();

    public void exportAppDefinition(HttpServletResponse response, String modelId) throws IOException {
        if (modelId == null) {
            throw new BadRequestException("No application definition id provided");
        }
        Model appModel = this.modelService.getModel(modelId);
        AppDefinitionRepresentation appRepresentation = this.createAppDefinitionRepresentation(appModel);
        this.createAppDefinitionZip(response, appModel, appRepresentation, SecurityUtils.getCurrentUserObject());
    }

    protected void createAppDefinitionZip(HttpServletResponse response, Model appModel, AppDefinitionRepresentation appDefinition, User user) {
        response.setHeader("Content-Disposition", "attachment; filename=" + appDefinition.getName() + ".zip");
        try {
            ServletOutputStream servletOutputStream = response.getOutputStream();
            response.setContentType("application/zip");
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)servletOutputStream);
            this.createZipEntry(zipOutputStream, appModel.getName() + ".json", this.createModelEntryJson(appModel));
            List<AppModelDefinition> modelDefinitions = appDefinition.getDefinition().getModels();
            if (CollectionUtils.isNotEmpty(modelDefinitions)) {
                HashMap<String, Model> formMap = new HashMap<String, Model>();
                HashMap<String, Model> decisionTableMap = new HashMap<String, Model>();
                for (AppModelDefinition modelDef : modelDefinitions) {
                    Model model = this.modelService.getModel(modelDef.getId());
                    List<Model> referencedModels = this.modelRepository.findModelsByParentModelId(model.getId());
                    for (Model childModel : referencedModels) {
                        if (2 == childModel.getModelType()) {
                            formMap.put(childModel.getId(), childModel);
                            continue;
                        }
                        if (4 != childModel.getModelType()) continue;
                        decisionTableMap.put(childModel.getId(), childModel);
                    }
                    this.createZipEntries(model, "bpmn-models", zipOutputStream);
                }
                for (Model formModel : formMap.values()) {
                    this.createZipEntries(formModel, "form-models", zipOutputStream);
                }
                for (Model decisionTableModel : decisionTableMap.values()) {
                    this.createZipEntries(decisionTableModel, "decision-table-models", zipOutputStream);
                }
            }
            zipOutputStream.close();
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (Exception e) {
            logger.error("Could not generate app definition zip archive", (Throwable)e);
            throw new InternalServerErrorException("Could not generate app definition zip archive");
        }
    }

    protected void createZipEntries(Model model, String directoryName, ZipOutputStream zipOutputStream) throws Exception {
        this.createZipEntry(zipOutputStream, directoryName + "/" + model.getKey() + ".json", this.createModelEntryJson(model));
        if (model.getThumbnail() != null) {
            this.createZipEntry(zipOutputStream, directoryName + "/" + model.getKey() + ".png", model.getThumbnail());
        }
    }

    protected String createModelEntryJson(Model model) {
        ObjectNode modelJson = this.objectMapper.createObjectNode();
        modelJson.put("id", model.getId());
        modelJson.put("name", model.getName());
        modelJson.put("key", model.getKey());
        modelJson.put("description", model.getDescription());
        try {
            modelJson.put("editorJson", this.objectMapper.readTree(model.getModelEditorJson()));
        }
        catch (Exception e) {
            logger.error("Error exporting model json for id " + model.getId(), (Throwable)e);
            throw new InternalServerErrorException("Error exporting model json for id " + model.getId());
        }
        return modelJson.toString();
    }

    protected AppDefinitionRepresentation createAppDefinitionRepresentation(AbstractModel model) {
        AppDefinition appDefinition = null;
        try {
            appDefinition = (AppDefinition)this.objectMapper.readValue(model.getModelEditorJson(), AppDefinition.class);
        }
        catch (Exception e) {
            logger.error("Error deserializing app " + model.getId(), (Throwable)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
        AppDefinitionRepresentation result = new AppDefinitionRepresentation(model);
        result.setDefinition(appDefinition);
        return result;
    }

    protected void createZipEntry(ZipOutputStream zipOutputStream, String filename, String content) throws Exception {
        this.createZipEntry(zipOutputStream, filename, content.getBytes(Charset.forName("UTF-8")));
    }

    protected void createZipEntry(ZipOutputStream zipOutputStream, String filename, byte[] content) throws Exception {
        ZipEntry entry = new ZipEntry(filename);
        zipOutputStream.putNextEntry(entry);
        zipOutputStream.write(content);
        zipOutputStream.closeEntry();
    }
}

