/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.editor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.app.domain.editor.AbstractModel;
import org.activiti.app.domain.editor.AppDefinition;
import org.activiti.app.domain.editor.AppModelDefinition;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.domain.editor.ModelHistory;
import org.activiti.app.repository.editor.ModelHistoryRepository;
import org.activiti.app.repository.editor.ModelRepository;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.AppDefinitionService;
import org.activiti.app.service.api.AppDefinitionServiceRepresentation;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppDefinitionServiceImpl
implements AppDefinitionService {
    private final Logger logger = LoggerFactory.getLogger(AppDefinitionServiceImpl.class);
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ModelHistoryRepository modelHistoryRepository;
    @Autowired
    protected ObjectMapper objectMapper;

    @Override
    public List<AppDefinitionServiceRepresentation> getAppDefinitions() {
        HashMap<String, Model> modelMap = new HashMap<String, Model>();
        ArrayList<AppDefinitionServiceRepresentation> resultList = new ArrayList<AppDefinitionServiceRepresentation>();
        User user = SecurityUtils.getCurrentUserObject();
        List<Model> createdByModels = this.modelRepository.findModelsCreatedBy(user.getId(), 3, new Sort(Sort.Direction.ASC, new String[]{"name"}));
        for (AbstractModel model : createdByModels) {
            modelMap.put(model.getId(), (Model)model);
        }
        for (AbstractModel model : modelMap.values()) {
            resultList.add(this.createAppDefinition(model));
        }
        return resultList;
    }

    @Override
    public List<AppDefinitionServiceRepresentation> getDeployableAppDefinitions(User user) {
        HashMap<String, ModelHistory> modelMap = new HashMap<String, ModelHistory>();
        ArrayList<AppDefinitionServiceRepresentation> resultList = new ArrayList<AppDefinitionServiceRepresentation>();
        List<ModelHistory> createdByModels = this.modelHistoryRepository.findByCreatedByAndModelTypeAndRemovalDateIsNull(user.getId(), 3);
        for (ModelHistory modelHistory : createdByModels) {
            if (modelMap.containsKey(modelHistory.getModelId())) {
                if (modelHistory.getVersion() <= ((ModelHistory)modelMap.get(modelHistory.getModelId())).getVersion()) continue;
                modelMap.put(modelHistory.getModelId(), modelHistory);
                continue;
            }
            modelMap.put(modelHistory.getModelId(), modelHistory);
        }
        for (ModelHistory model : modelMap.values()) {
            Model latestModel = (Model)this.modelRepository.findOne((Serializable)((Object)model.getModelId()));
            if (latestModel == null) continue;
            resultList.add(this.createAppDefinition(model));
        }
        return resultList;
    }

    protected AppDefinitionServiceRepresentation createAppDefinition(AbstractModel model) {
        AppDefinitionServiceRepresentation resultInfo = new AppDefinitionServiceRepresentation();
        if (model instanceof ModelHistory) {
            resultInfo.setId(((ModelHistory)model).getModelId());
        } else {
            resultInfo.setId(model.getId());
        }
        resultInfo.setName(model.getName());
        resultInfo.setDescription(model.getDescription());
        resultInfo.setVersion(model.getVersion());
        resultInfo.setDefinition(model.getModelEditorJson());
        AppDefinition appDefinition = null;
        try {
            appDefinition = (AppDefinition)this.objectMapper.readValue(model.getModelEditorJson(), AppDefinition.class);
        }
        catch (Exception e) {
            this.logger.error("Error deserializing app " + model.getId(), (Throwable)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
        if (appDefinition != null) {
            resultInfo.setTheme(appDefinition.getTheme());
            resultInfo.setIcon(appDefinition.getIcon());
            List<AppModelDefinition> models = appDefinition.getModels();
            if (CollectionUtils.isNotEmpty(models)) {
                ArrayList<String> modelIds = new ArrayList<String>();
                for (AppModelDefinition appModelDef : models) {
                    modelIds.add(appModelDef.getId());
                }
                resultInfo.setModels(modelIds);
            }
        }
        return resultInfo;
    }

    @Override
    public String getDefinitionIdForModelAndUser(String modelId, User user) {
        String appDefinitionId = this.modelRepository.appDefinitionIdByModelAndUser(modelId, user.getId());
        return appDefinitionId;
    }
}

