/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.editor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.app.domain.editor.AbstractModel;
import org.activiti.app.domain.editor.AppDefinition;
import org.activiti.app.domain.editor.AppModelDefinition;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.domain.editor.ModelHistory;
import org.activiti.app.domain.editor.ModelRelation;
import org.activiti.app.model.editor.ModelKeyRepresentation;
import org.activiti.app.model.editor.ModelRepresentation;
import org.activiti.app.model.editor.ReviveModelResultRepresentation;
import org.activiti.app.repository.editor.ModelHistoryRepository;
import org.activiti.app.repository.editor.ModelRelationRepository;
import org.activiti.app.repository.editor.ModelRepository;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.AppDefinitionService;
import org.activiti.app.service.api.DeploymentService;
import org.activiti.app.service.api.ModelService;
import org.activiti.app.service.api.UserCache;
import org.activiti.app.service.editor.ModelImageService;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.editor.language.json.converter.util.JsonConverterUtil;
import org.activiti.engine.identity.User;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModelServiceImpl
implements ModelService {
    private final Logger log = LoggerFactory.getLogger(ModelServiceImpl.class);
    public static final String NAMESPACE = "http://activiti.com/modeler";
    protected static final String PROCESS_NOT_FOUND_MESSAGE_KEY = "PROCESS.ERROR.NOT-FOUND";
    @Autowired
    protected DeploymentService deploymentService;
    @Autowired
    protected ModelImageService modelImageService;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ModelHistoryRepository modelHistoryRepository;
    @Autowired
    protected ModelRelationRepository modelRelationRepository;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected UserCache userCache;
    @Autowired
    protected AppDefinitionService appDefinitionService;
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
    protected BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();

    @Override
    public Model getModel(String modelId) {
        Model model = (Model)this.modelRepository.findOne((Serializable)((Object)modelId));
        if (model == null) {
            NotFoundException modelNotFound = new NotFoundException("No model found with the given id: " + modelId);
            modelNotFound.setMessageKey(PROCESS_NOT_FOUND_MESSAGE_KEY);
            throw modelNotFound;
        }
        return model;
    }

    @Override
    public List<AbstractModel> getModelsByModelType(Integer modelType) {
        return new ArrayList<AbstractModel>(this.modelRepository.findModelsByModelType(modelType));
    }

    @Override
    public ModelHistory getModelHistory(String modelId, String modelHistoryId) {
        Model model = this.getModel(modelId);
        ModelHistory modelHistory = (ModelHistory)this.modelHistoryRepository.findOne((Serializable)((Object)modelHistoryId));
        if (modelHistory == null || modelHistory.getRemovalDate() != null || !modelHistory.getModelId().equals(model.getId())) {
            throw new NotFoundException("Process model history not found: " + modelHistoryId);
        }
        return modelHistory;
    }

    @Override
    public byte[] getBpmnXML(AbstractModel model) {
        BpmnModel bpmnModel = this.getBpmnModel(model);
        return this.getBpmnXML(bpmnModel);
    }

    @Override
    public byte[] getBpmnXML(BpmnModel bpmnModel) {
        for (Process process : bpmnModel.getProcesses()) {
            char firstCharacter;
            if (!StringUtils.isNotEmpty((CharSequence)process.getId()) || !Character.isDigit(firstCharacter = process.getId().charAt(0))) continue;
            process.setId("a" + process.getId());
        }
        byte[] xmlBytes = this.bpmnXMLConverter.convertToXML(bpmnModel);
        return xmlBytes;
    }

    @Override
    public ModelKeyRepresentation validateModelKey(Model model, Integer modelType, String key) {
        ModelKeyRepresentation modelKeyResponse = new ModelKeyRepresentation();
        modelKeyResponse.setKey(key);
        List<Model> models = this.modelRepository.findModelsByKeyAndType(key, modelType);
        for (Model modelInfo : models) {
            if (model != null && modelInfo.getId().equals(model.getId())) continue;
            modelKeyResponse.setKeyAlreadyExists(true);
            modelKeyResponse.setId(modelInfo.getId());
            modelKeyResponse.setName(modelInfo.getName());
            break;
        }
        return modelKeyResponse;
    }

    @Override
    @Transactional
    public Model createModel(Model newModel, User createdBy) {
        newModel.setVersion(1);
        newModel.setCreated(Calendar.getInstance().getTime());
        newModel.setCreatedBy(createdBy.getId());
        newModel.setLastUpdated(Calendar.getInstance().getTime());
        newModel.setLastUpdatedBy(createdBy.getId());
        this.persistModel(newModel);
        return newModel;
    }

    @Override
    @Transactional
    public Model createModel(ModelRepresentation model, String editorJson, User createdBy) {
        Model newModel = new Model();
        newModel.setVersion(1);
        newModel.setName(model.getName());
        newModel.setKey(model.getKey());
        newModel.setModelType(model.getModelType());
        newModel.setCreated(Calendar.getInstance().getTime());
        newModel.setCreatedBy(createdBy.getId());
        newModel.setDescription(model.getDescription());
        newModel.setModelEditorJson(editorJson);
        newModel.setLastUpdated(Calendar.getInstance().getTime());
        newModel.setLastUpdatedBy(createdBy.getId());
        this.persistModel(newModel);
        return newModel;
    }

    @Override
    @Transactional
    public Model createNewModelVersion(Model modelObject, String comment, User updatedBy) {
        return (Model)this.internalCreateNewModelVersion(modelObject, comment, updatedBy, false);
    }

    @Override
    @Transactional
    public ModelHistory createNewModelVersionAndReturnModelHistory(Model modelObject, String comment, User updatedBy) {
        return (ModelHistory)this.internalCreateNewModelVersion(modelObject, comment, updatedBy, true);
    }

    protected AbstractModel internalCreateNewModelVersion(Model modelObject, String comment, User updatedBy, boolean returnModelHistory) {
        modelObject.setLastUpdated(new Date());
        modelObject.setLastUpdatedBy(updatedBy.getId());
        modelObject.setComment(comment);
        ModelHistory historyModel = this.createNewModelhistory(modelObject);
        this.persistModelHistory(historyModel);
        modelObject.setVersion(modelObject.getVersion() + 1);
        this.persistModel(modelObject);
        return returnModelHistory ? historyModel : modelObject;
    }

    @Override
    public Model saveModel(Model modelObject) {
        return this.persistModel(modelObject);
    }

    @Override
    @Transactional
    public Model saveModel(Model modelObject, String editorJson, byte[] imageBytes, boolean newVersion, String newVersionComment, User updatedBy) {
        return this.internalSave(modelObject.getName(), modelObject.getKey(), modelObject.getDescription(), editorJson, newVersion, newVersionComment, imageBytes, updatedBy, modelObject);
    }

    @Override
    @Transactional
    public Model saveModel(String modelId, String name, String key, String description, String editorJson, boolean newVersion, String newVersionComment, User updatedBy) {
        Model modelObject = (Model)this.modelRepository.findOne((Serializable)((Object)modelId));
        return this.internalSave(name, key, description, editorJson, newVersion, newVersionComment, null, updatedBy, modelObject);
    }

    protected Model internalSave(String name, String key, String description, String editorJson, boolean newVersion, String newVersionComment, byte[] imageBytes, User updatedBy, Model modelObject) {
        if (!newVersion) {
            modelObject.setLastUpdated(new Date());
            modelObject.setLastUpdatedBy(updatedBy.getId());
            modelObject.setName(name);
            modelObject.setKey(key);
            modelObject.setDescription(description);
            modelObject.setModelEditorJson(editorJson);
            if (imageBytes != null) {
                modelObject.setThumbnail(imageBytes);
            }
        } else {
            ModelHistory historyModel = this.createNewModelhistory(modelObject);
            this.persistModelHistory(historyModel);
            modelObject.setVersion(modelObject.getVersion() + 1);
            modelObject.setLastUpdated(new Date());
            modelObject.setLastUpdatedBy(updatedBy.getId());
            modelObject.setName(name);
            modelObject.setKey(key);
            modelObject.setDescription(description);
            modelObject.setModelEditorJson(editorJson);
            modelObject.setComment(newVersionComment);
            if (imageBytes != null) {
                modelObject.setThumbnail(imageBytes);
            }
        }
        return this.persistModel(modelObject);
    }

    @Override
    @Transactional
    public void deleteModel(String modelId, boolean cascadeHistory, boolean deleteRuntimeApp) {
        Model model = (Model)this.modelRepository.findOne((Serializable)((Object)modelId));
        if (model == null) {
            throw new IllegalArgumentException("No model found with id: " + modelId);
        }
        List<ModelHistory> history = this.modelHistoryRepository.findByModelIdAndRemovalDateIsNullOrderByVersionDesc(model.getId());
        if (deleteRuntimeApp && model.getModelType() == 3) {
            String appDefinitionId = this.appDefinitionService.getDefinitionIdForModelAndUser(model.getId(), SecurityUtils.getCurrentUserObject());
            if (appDefinitionId != null) {
                this.deploymentService.deleteAppDefinition(appDefinitionId);
            }
        } else {
            ModelHistory historyModel = this.createNewModelhistory(model);
            historyModel.setRemovalDate(Calendar.getInstance().getTime());
            this.persistModelHistory(historyModel);
        }
        if (cascadeHistory || history.size() == 0) {
            this.deleteModelAndChildren(model);
        } else {
            ModelHistory toRevive = history.remove(0);
            this.populateModelBasedOnHistory(model, toRevive);
            this.persistModel(model);
            this.modelHistoryRepository.delete(toRevive);
        }
    }

    protected void deleteModelAndChildren(Model model) {
        ArrayList<Model> allModels = new ArrayList<Model>();
        this.internalDeleteModelAndChildren(model, allModels);
        for (Model modelToDelete : allModels) {
            this.modelRepository.delete(modelToDelete);
        }
    }

    protected void internalDeleteModelAndChildren(Model model, List<Model> allModels) {
        this.modelRelationRepository.deleteModelRelationsForParentModel(model.getId());
        allModels.add(model);
    }

    @Override
    @Transactional
    public ReviveModelResultRepresentation reviveProcessModelHistory(ModelHistory modelHistory, User user, String newVersionComment) {
        Model latestModel = (Model)this.modelRepository.findOne((Serializable)((Object)modelHistory.getModelId()));
        if (latestModel == null) {
            throw new IllegalArgumentException("No process model found with id: " + modelHistory.getModelId());
        }
        ModelHistory latestModelHistory = this.createNewModelhistory(latestModel);
        this.persistModelHistory(latestModelHistory);
        latestModel.setVersion(latestModel.getVersion() + 1);
        latestModel.setLastUpdated(new Date());
        latestModel.setLastUpdatedBy(user.getId());
        latestModel.setName(modelHistory.getName());
        latestModel.setKey(modelHistory.getKey());
        latestModel.setDescription(modelHistory.getDescription());
        latestModel.setModelEditorJson(modelHistory.getModelEditorJson());
        latestModel.setModelType(modelHistory.getModelType());
        latestModel.setComment(newVersionComment);
        this.persistModel(latestModel);
        ReviveModelResultRepresentation result = new ReviveModelResultRepresentation();
        if (latestModel.getModelType() == 3 && StringUtils.isNotEmpty((CharSequence)latestModel.getModelEditorJson())) {
            try {
                AppDefinition appDefinition = (AppDefinition)this.objectMapper.readValue(latestModel.getModelEditorJson(), AppDefinition.class);
                for (AppModelDefinition appModelDefinition : appDefinition.getModels()) {
                    if (this.modelRepository.exists((Serializable)((Object)appModelDefinition.getId()))) continue;
                    result.getUnresolvedModels().add(new ReviveModelResultRepresentation.UnresolveModelRepresentation(appModelDefinition.getId(), appModelDefinition.getName(), appModelDefinition.getLastUpdatedBy()));
                }
            }
            catch (Exception e) {
                this.log.error("Could not deserialize app model json (id = " + latestModel.getId() + ")", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public BpmnModel getBpmnModel(AbstractModel model) {
        BpmnModel bpmnModel = null;
        try {
            HashMap<String, Model> formMap = new HashMap<String, Model>();
            HashMap<String, Model> decisionTableMap = new HashMap<String, Model>();
            List<Model> referencedModels = this.modelRepository.findModelsByParentModelId(model.getId());
            for (Model childModel : referencedModels) {
                if (2 == childModel.getModelType()) {
                    formMap.put(childModel.getId(), childModel);
                    continue;
                }
                if (4 != childModel.getModelType()) continue;
                decisionTableMap.put(childModel.getId(), childModel);
            }
            bpmnModel = this.getBpmnModel(model, formMap, decisionTableMap);
        }
        catch (Exception e) {
            this.log.error("Could not generate BPMN 2.0 model for " + model.getId(), (Throwable)e);
            throw new InternalServerErrorException("Could not generate BPMN 2.0 model");
        }
        return bpmnModel;
    }

    @Override
    public BpmnModel getBpmnModel(AbstractModel model, Map<String, Model> formMap, Map<String, Model> decisionTableMap) {
        try {
            ObjectNode editorJsonNode = (ObjectNode)this.objectMapper.readTree(model.getModelEditorJson());
            HashMap<String, String> formKeyMap = new HashMap<String, String>();
            for (Model formModel : formMap.values()) {
                formKeyMap.put(formModel.getId(), formModel.getKey());
            }
            HashMap<String, String> decisionTableKeyMap = new HashMap<String, String>();
            for (Model decisionTableModel : decisionTableMap.values()) {
                decisionTableKeyMap.put(decisionTableModel.getId(), decisionTableModel.getKey());
            }
            return this.bpmnJsonConverter.convertToBpmnModel((JsonNode)editorJsonNode, formKeyMap, decisionTableKeyMap);
        }
        catch (Exception e) {
            this.log.error("Could not generate BPMN 2.0 model for " + model.getId(), (Throwable)e);
            throw new InternalServerErrorException("Could not generate BPMN 2.0 model");
        }
    }

    protected void addOrUpdateExtensionElement(String name, String value, UserTask userTask) {
        List extensionElements = (List)userTask.getExtensionElements().get(name);
        ExtensionElement extensionElement = CollectionUtils.isNotEmpty((Collection)extensionElements) ? (ExtensionElement)extensionElements.get(0) : new ExtensionElement();
        extensionElement.setNamespace(NAMESPACE);
        extensionElement.setNamespacePrefix("modeler");
        extensionElement.setName(name);
        extensionElement.setElementText(value);
        if (CollectionUtils.isEmpty((Collection)extensionElements)) {
            userTask.addExtensionElement(extensionElement);
        }
    }

    @Override
    public Long getModelCountForUser(User user, int modelType) {
        return this.modelRepository.countByModelTypeAndUser(modelType, user.getId());
    }

    protected Model persistModel(Model model) {
        if (StringUtils.isNotEmpty((CharSequence)(model = (Model)this.modelRepository.save(model)).getModelEditorJson())) {
            ObjectNode jsonNode = null;
            try {
                jsonNode = (ObjectNode)this.objectMapper.readTree(model.getModelEditorJson());
            }
            catch (Exception e) {
                this.log.error("Could not deserialize json model", (Throwable)e);
                throw new InternalServerErrorException("Could not deserialize json model");
            }
            if (model.getModelType() == null || model.getModelType() == 0) {
                this.modelImageService.generateThumbnailImage(model, jsonNode);
                this.handleBpmnProcessFormModelRelations(model, jsonNode);
                this.handleBpmnProcessDecisionTaskModelRelations(model, jsonNode);
            } else if (model.getModelType() == 2 || model.getModelType() == 4) {
                jsonNode.put("name", model.getName());
                jsonNode.put("key", model.getKey());
            } else if (model.getModelType() == 3) {
                this.handleAppModelProcessRelations(model, jsonNode);
            }
        }
        return model;
    }

    protected ModelHistory persistModelHistory(ModelHistory modelHistory) {
        return (ModelHistory)this.modelHistoryRepository.save(modelHistory);
    }

    protected void handleBpmnProcessFormModelRelations(AbstractModel bpmnProcessModel, ObjectNode editorJsonNode) {
        List formReferenceNodes = JsonConverterUtil.filterOutJsonNodes((List)JsonConverterUtil.getBpmnProcessModelFormReferences((JsonNode)editorJsonNode));
        Set formIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)formReferenceNodes, (String)"id");
        this.handleModelRelations(bpmnProcessModel, formIds, "form-model");
    }

    protected void handleBpmnProcessDecisionTaskModelRelations(AbstractModel bpmnProcessModel, ObjectNode editorJsonNode) {
        List decisionTableNodes = JsonConverterUtil.filterOutJsonNodes((List)JsonConverterUtil.getBpmnProcessModelDecisionTableReferences((JsonNode)editorJsonNode));
        Set decisionTableIds = JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable)decisionTableNodes, (String)"id");
        this.handleModelRelations(bpmnProcessModel, decisionTableIds, "decision-table-model");
    }

    protected void handleAppModelProcessRelations(AbstractModel appModel, ObjectNode appModelJsonNode) {
        Set processModelIds = JsonConverterUtil.getAppModelReferencedModelIds((JsonNode)appModelJsonNode);
        this.handleModelRelations(appModel, processModelIds, "process-model");
    }

    protected void handleModelRelations(AbstractModel bpmnProcessModel, Set<String> idsReferencedInJson, String relationshipType) {
        List<ModelRelation> persistedModelRelations = this.modelRelationRepository.findByParentModelIdAndType(bpmnProcessModel.getId(), relationshipType);
        if (idsReferencedInJson == null || idsReferencedInJson.size() == 0) {
            this.modelRelationRepository.delete(persistedModelRelations);
            return;
        }
        HashSet<String> alreadyPersistedModelIds = new HashSet<String>(persistedModelRelations.size());
        for (ModelRelation persistedModelRelation : persistedModelRelations) {
            if (!idsReferencedInJson.contains(persistedModelRelation.getModelId())) {
                this.modelRelationRepository.delete(persistedModelRelation);
                continue;
            }
            alreadyPersistedModelIds.add(persistedModelRelation.getModelId());
        }
        for (String idReferencedInJson : idsReferencedInJson) {
            if (alreadyPersistedModelIds.contains(idReferencedInJson) || !this.modelRepository.exists((Serializable)((Object)idReferencedInJson))) continue;
            this.modelRelationRepository.save(new ModelRelation(bpmnProcessModel.getId(), idReferencedInJson, relationshipType));
        }
    }

    protected ModelHistory createNewModelhistory(Model model) {
        ModelHistory historyModel = new ModelHistory();
        historyModel.setName(model.getName());
        historyModel.setKey(model.getKey());
        historyModel.setDescription(model.getDescription());
        historyModel.setCreated(model.getCreated());
        historyModel.setLastUpdated(model.getLastUpdated());
        historyModel.setCreatedBy(model.getCreatedBy());
        historyModel.setLastUpdatedBy(model.getLastUpdatedBy());
        historyModel.setModelEditorJson(model.getModelEditorJson());
        historyModel.setModelType(model.getModelType());
        historyModel.setVersion(model.getVersion());
        historyModel.setModelId(model.getId());
        historyModel.setComment(model.getComment());
        return historyModel;
    }

    protected void populateModelBasedOnHistory(Model model, ModelHistory basedOn) {
        model.setName(basedOn.getName());
        model.setKey(basedOn.getKey());
        model.setDescription(basedOn.getDescription());
        model.setCreated(basedOn.getCreated());
        model.setLastUpdated(basedOn.getLastUpdated());
        model.setCreatedBy(basedOn.getCreatedBy());
        model.setLastUpdatedBy(basedOn.getLastUpdatedBy());
        model.setModelEditorJson(basedOn.getModelEditorJson());
        model.setModelType(basedOn.getModelType());
        model.setVersion(basedOn.getVersion());
        model.setComment(basedOn.getComment());
    }
}

