/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.camel;

import java.util.Map;
import org.activiti.camel.ActivitiEndpoint;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.IntrospectionSupport;

public class ActivitiComponent
extends DefaultComponent {
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected boolean copyVariablesToProperties;
    protected boolean copyVariablesToBodyAsMap;
    protected boolean copyCamelBodyToBody;

    public void setCamelContext(CamelContext context) {
        super.setCamelContext(context);
        this.identityService = this.getByType(context, IdentityService.class);
        this.runtimeService = this.getByType(context, RuntimeService.class);
    }

    private <T> T getByType(CamelContext ctx, Class<T> kls) {
        Map looked = ctx.getRegistry().findByTypeWithName(kls);
        if (looked.isEmpty()) {
            return null;
        }
        return (T)looked.values().iterator().next();
    }

    protected Endpoint createEndpoint(String s, String s1, Map<String, Object> parameters) throws Exception {
        ActivitiEndpoint ae = new ActivitiEndpoint(s, this.getCamelContext());
        ae.setIdentityService(this.identityService);
        ae.setRuntimeService(this.runtimeService);
        ae.setCopyVariablesToProperties(this.copyVariablesToProperties);
        ae.setCopyVariablesToBodyAsMap(this.copyVariablesToBodyAsMap);
        ae.setCopyCamelBodyToBody(this.copyCamelBodyToBody);
        Map returnVars = IntrospectionSupport.extractProperties(parameters, (String)"var.return.");
        if (returnVars != null && returnVars.size() > 0) {
            ae.getReturnVarMap().putAll(returnVars);
        }
        return ae;
    }

    public boolean isCopyVariablesToProperties() {
        return this.copyVariablesToProperties;
    }

    public void setCopyVariablesToProperties(boolean copyVariablesToProperties) {
        this.copyVariablesToProperties = copyVariablesToProperties;
    }

    public boolean isCopyCamelBodyToBody() {
        return this.copyCamelBodyToBody;
    }

    public void setCopyCamelBodyToBody(boolean copyCamelBodyToBody) {
        this.copyCamelBodyToBody = copyCamelBodyToBody;
    }

    public boolean isCopyVariablesToBodyAsMap() {
        return this.copyVariablesToBodyAsMap;
    }

    public void setCopyVariablesToBodyAsMap(boolean copyVariablesToBodyAsMap) {
        this.copyVariablesToBodyAsMap = copyVariablesToBodyAsMap;
    }
}

