/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.camel;

import java.util.HashMap;
import java.util.Map;
import org.activiti.camel.ActivitiConsumer;
import org.activiti.camel.ActivitiProducer;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.commons.lang3.StringUtils;

public class ActivitiEndpoint
extends DefaultEndpoint {
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected ActivitiConsumer activitiConsumer;
    protected boolean copyVariablesToProperties;
    protected boolean copyVariablesToBodyAsMap;
    protected boolean copyCamelBodyToBody;
    protected String copyVariablesFromProperties;
    protected String copyVariablesFromHeader;
    protected boolean copyCamelBodyToBodyAsString;
    protected String processInitiatorHeaderName;
    protected Map<String, Object> returnVarMap = new HashMap<String, Object>();
    protected long timeout = 5000L;
    protected int timeResolution = 100;

    public ActivitiEndpoint(String uri, CamelContext camelContext) {
        this.setCamelContext(camelContext);
        this.setEndpointUri(uri);
    }

    public void process(Exchange ex) throws Exception {
        if (this.activitiConsumer == null) {
            throw new ActivitiException("Activiti consumer not defined for " + this.getEndpointUri());
        }
        this.activitiConsumer.getProcessor().process(ex);
    }

    public Producer createProducer() throws Exception {
        ActivitiProducer producer = new ActivitiProducer(this, this.getTimeout(), this.getTimeResolution());
        producer.setRuntimeService(this.runtimeService);
        producer.setIdentityService(this.identityService);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new ActivitiConsumer(this, processor);
    }

    protected void addConsumer(ActivitiConsumer consumer) {
        if (this.activitiConsumer != null) {
            throw new ActivitiException("Activiti consumer already defined for " + this.getEndpointUri() + "!");
        }
        this.activitiConsumer = consumer;
    }

    protected void removeConsumer() {
        this.activitiConsumer = null;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public boolean isCopyVariablesToProperties() {
        return this.copyVariablesToProperties;
    }

    public void setCopyVariablesToProperties(boolean copyVariablesToProperties) {
        this.copyVariablesToProperties = copyVariablesToProperties;
    }

    public boolean isCopyCamelBodyToBody() {
        return this.copyCamelBodyToBody;
    }

    public void setCopyCamelBodyToBody(boolean copyCamelBodyToBody) {
        this.copyCamelBodyToBody = copyCamelBodyToBody;
    }

    public boolean isCopyVariablesToBodyAsMap() {
        return this.copyVariablesToBodyAsMap;
    }

    public void setCopyVariablesToBodyAsMap(boolean copyVariablesToBodyAsMap) {
        this.copyVariablesToBodyAsMap = copyVariablesToBodyAsMap;
    }

    public String getCopyVariablesFromProperties() {
        return this.copyVariablesFromProperties;
    }

    public void setCopyVariablesFromProperties(String copyVariablesFromProperties) {
        this.copyVariablesFromProperties = copyVariablesFromProperties;
    }

    public String getCopyVariablesFromHeader() {
        return this.copyVariablesFromHeader;
    }

    public void setCopyVariablesFromHeader(String copyVariablesFromHeader) {
        this.copyVariablesFromHeader = copyVariablesFromHeader;
    }

    public boolean isCopyCamelBodyToBodyAsString() {
        return this.copyCamelBodyToBodyAsString;
    }

    public void setCopyCamelBodyToBodyAsString(boolean copyCamelBodyToBodyAsString) {
        this.copyCamelBodyToBodyAsString = copyCamelBodyToBodyAsString;
    }

    public boolean isSetProcessInitiator() {
        return StringUtils.isNotEmpty((CharSequence)this.getProcessInitiatorHeaderName());
    }

    public Map<String, Object> getReturnVarMap() {
        return this.returnVarMap;
    }

    public void setReturnVarMap(Map<String, Object> returnVarMap) {
        this.returnVarMap = returnVarMap;
    }

    public String getProcessInitiatorHeaderName() {
        return this.processInitiatorHeaderName;
    }

    public void setProcessInitiatorHeaderName(String processInitiatorHeaderName) {
        this.processInitiatorHeaderName = processInitiatorHeaderName;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getTimeResolution() {
        return this.timeResolution;
    }
}

