/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ExplorerFilter
implements Filter {
    private List<String> ignoreList = new ArrayList<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.ignoreList.add("/ui");
        this.ignoreList.add("/VAADIN");
        this.ignoreList.add("/api");
        this.ignoreList.add("/editor");
        this.ignoreList.add("/explorer");
        this.ignoreList.add("/libs");
        this.ignoreList.add("/service");
        this.ignoreList.add("/diagram-viewer");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String path = req.getRequestURI().substring(req.getContextPath().length());
        int indexSlash = path.indexOf("/", 1);
        String firstPart = null;
        firstPart = indexSlash > 0 ? path.substring(0, indexSlash) : path;
        if (this.ignoreList.contains(firstPart)) {
            chain.doFilter(request, response);
        } else {
            request.getRequestDispatcher("/ui" + path).forward(request, response);
        }
    }

    public void destroy() {
    }
}

