/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process.simple.editor;

import com.vaadin.data.Item;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ui.process.simple.editor.table.PropertyTable;
import org.activiti.explorer.ui.process.simple.editor.table.TaskFormModel;
import org.activiti.workflow.simple.definition.form.DatePropertyDefinition;
import org.activiti.workflow.simple.definition.form.FormDefinition;
import org.activiti.workflow.simple.definition.form.FormPropertyDefinition;
import org.activiti.workflow.simple.definition.form.NumberPropertyDefinition;
import org.activiti.workflow.simple.definition.form.TextPropertyDefinition;

public class FormPopupWindow
extends Window {
    protected static final long serialVersionUID = -1754225937375971709L;
    protected static final String TITLE = "Define form";
    protected static final String DESCRIPTION = "Define the form properties that will be shown with the task";
    protected Object taskItemId;
    protected TaskFormModel formModel;
    protected PropertyTable propertyTable;

    public FormPopupWindow(Object taskItemId, TaskFormModel formModel) {
        this.taskItemId = taskItemId;
        this.formModel = formModel;
        this.setModal(true);
        this.setWidth("50%");
        this.center();
        this.setCaption(TITLE);
        this.initUi();
    }

    protected void initUi() {
        VerticalLayout layout = new VerticalLayout();
        layout.setSpacing(true);
        this.addComponent((Component)layout);
        layout.addComponent((Component)new Label(DESCRIPTION));
        this.propertyTable = new PropertyTable();
        layout.addComponent((Component)this.propertyTable);
        this.fillFormFields();
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.setSpacing(true);
        Button saveButton = new Button(ExplorerApp.get().getI18nManager().getMessage("button.save"));
        buttons.addComponent((Component)saveButton);
        saveButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = -2906886872414089331L;

            public void buttonClick(Button.ClickEvent event) {
                FormDefinition form = FormPopupWindow.this.createForm();
                FormPopupWindow.this.formModel.addForm(FormPopupWindow.this.taskItemId, form);
                FormPopupWindow.this.close();
            }
        });
        Button deleteButton = new Button(ExplorerApp.get().getI18nManager().getMessage("button.delete"));
        buttons.addComponent((Component)deleteButton);
        deleteButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5267967369680365653L;

            public void buttonClick(Button.ClickEvent event) {
                FormPopupWindow.this.formModel.removeForm(FormPopupWindow.this.taskItemId);
                FormPopupWindow.this.close();
            }
        });
        layout.addComponent((Component)new Label(""));
        layout.addComponent((Component)buttons);
    }

    public FormDefinition createForm() {
        FormDefinition formDefinition = new FormDefinition();
        for (Object itemId : this.propertyTable.getItemIds()) {
            Item item = this.propertyTable.getItem(itemId);
            FormPropertyDefinition formPropertyDefinition = this.getFormPropertyDefinition(item);
            formDefinition.addFormProperty(formPropertyDefinition);
        }
        return formDefinition;
    }

    protected FormPropertyDefinition getFormPropertyDefinition(Item item) {
        String type = (String)((ComboBox)item.getItemProperty((Object)"type").getValue()).getValue();
        Object result = null;
        result = type.equals("number") ? new NumberPropertyDefinition() : (type.equals("date") ? new DatePropertyDefinition() : new TextPropertyDefinition());
        result.setName((String)item.getItemProperty((Object)"property").getValue());
        result.setMandatory(((Boolean)((CheckBox)item.getItemProperty((Object)"required").getValue()).getValue()).booleanValue());
        return result;
    }

    protected void fillFormFields() {
        FormDefinition form = this.formModel.getForm(this.taskItemId);
        if (form == null) {
            this.propertyTable.addPropertyRow();
        } else {
            for (FormPropertyDefinition property : form.getFormPropertyDefinitions()) {
                this.propertyTable.addPropertyRow(property.getName(), this.getPropertyTypeDisplay(property), property.isMandatory());
            }
        }
    }

    protected String getPropertyTypeDisplay(FormPropertyDefinition definition) {
        if (definition instanceof NumberPropertyDefinition) {
            return "number";
        }
        if (definition instanceof DatePropertyDefinition) {
            return "date";
        }
        return "text";
    }
}

