/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.profile;

import com.vaadin.data.Property;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.Form;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import java.util.HashMap;
import java.util.Map;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.TabbedSelectionWindow;
import org.activiti.explorer.ui.event.SubmitEvent;

public class AccountSelectionPopup
extends TabbedSelectionWindow {
    private static final long serialVersionUID = 1L;
    protected I18nManager i18nManager;
    protected Form imapForm;
    protected Button.ClickListener imapClickListener;
    protected Form alfrescoForm;
    protected Button.ClickListener alfrescoClickListener;

    public AccountSelectionPopup(String title) {
        super(title);
        this.setWidth(600.0f, 0);
        this.setHeight(400.0f, 0);
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.initImapComponent();
        String imap = this.i18nManager.getMessage("profile.account.imap");
        this.addSelectionItem(new Embedded(null, Images.IMAP), imap, (Component)this.imapForm, this.imapClickListener);
        this.initAlfrescoComponent();
        this.addSelectionItem(new Embedded(null, Images.ALFRESCO), this.i18nManager.getMessage("profile.account.alfresco"), (Component)this.alfrescoForm, this.alfrescoClickListener);
        this.selectionTable.select((Object)imap);
    }

    protected void initImapComponent() {
        this.imapForm = new Form();
        this.imapForm.setDescription(this.i18nManager.getMessage("imap.description"));
        final TextField imapServer = new TextField(this.i18nManager.getMessage("imap.server"));
        this.imapForm.getLayout().addComponent((Component)imapServer);
        final TextField imapPort = new TextField(this.i18nManager.getMessage("imap.port"));
        imapPort.setWidth(30.0f, 0);
        imapPort.setValue((Object)143);
        this.imapForm.getLayout().addComponent((Component)imapPort);
        final CheckBox useSSL = new CheckBox(this.i18nManager.getMessage("imap.ssl"));
        useSSL.setValue((Object)false);
        useSSL.setImmediate(true);
        this.imapForm.getLayout().addComponent((Component)useSSL);
        useSSL.addListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                imapPort.setValue((Object)((Boolean)useSSL.getValue() != false ? 993 : 143));
            }
        });
        final TextField imapUserName = new TextField(this.i18nManager.getMessage("imap.username"));
        this.imapForm.getLayout().addComponent((Component)imapUserName);
        final PasswordField imapPassword = new PasswordField(this.i18nManager.getMessage("imap.password"));
        this.imapForm.getLayout().addComponent((Component)imapPassword);
        this.imapClickListener = new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                Map<String, Object> accountDetails = AccountSelectionPopup.this.createAccountDetails("imap", imapUserName.getValue().toString(), imapPassword.getValue().toString(), "server", imapServer.getValue().toString(), "port", imapPort.getValue().toString(), "ssl", imapPort.getValue().toString());
                AccountSelectionPopup.this.fireEvent(new SubmitEvent((Component)AccountSelectionPopup.this, "submit", accountDetails));
            }
        };
    }

    protected void initAlfrescoComponent() {
        this.alfrescoForm = new Form();
        this.alfrescoForm.setDescription(this.i18nManager.getMessage("alfresco.description"));
        final TextField alfrescoServer = new TextField(this.i18nManager.getMessage("alfresco.server"));
        this.alfrescoForm.getLayout().addComponent((Component)alfrescoServer);
        final TextField alfrescoUserName = new TextField(this.i18nManager.getMessage("alfresco.username"));
        this.alfrescoForm.getLayout().addComponent((Component)alfrescoUserName);
        final PasswordField alfrescoPassword = new PasswordField(this.i18nManager.getMessage("alfresco.password"));
        this.alfrescoForm.getLayout().addComponent((Component)alfrescoPassword);
        this.alfrescoClickListener = new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                Map<String, Object> accountDetails = AccountSelectionPopup.this.createAccountDetails("alfresco", alfrescoUserName.getValue().toString(), alfrescoPassword.getValue().toString(), "server", alfrescoServer.getValue().toString());
                AccountSelectionPopup.this.fireEvent(new SubmitEvent((Component)AccountSelectionPopup.this, "submit", accountDetails));
            }
        };
    }

    protected Map<String, Object> createAccountDetails(String acountName, String userName, String password, String ... additionalDetails) {
        HashMap<String, Object> accountDetails = new HashMap<String, Object>();
        accountDetails.put("accountName", acountName);
        accountDetails.put("userName", userName);
        accountDetails.put("password", password);
        if (additionalDetails != null && additionalDetails.length > 0) {
            HashMap<String, String> additional = new HashMap<String, String>();
            for (int i = 0; i < additionalDetails.length; i += 2) {
                additional.put(additionalDetails[i], additionalDetails[i + 1]);
            }
            accountDetails.put("additional", additional);
        }
        return accountDetails;
    }
}

