/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import java.text.MessageFormat;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ui.AbstractPage;
import org.activiti.explorer.ui.form.FormPropertiesEventListener;
import org.activiti.explorer.ui.form.FormPropertiesForm;
import org.activiti.explorer.ui.process.AbstractProcessDefinitionDetailPanel;
import org.activiti.explorer.ui.process.ProcessDefinitionPage;
import org.activiti.explorer.ui.process.listener.ConvertProcessDefinitionToModelClickListener;
import org.activiti.explorer.ui.process.listener.StartProcessInstanceClickListener;

public class ProcessDefinitionDetailPanel
extends AbstractProcessDefinitionDetailPanel {
    private static final long serialVersionUID = 1L;
    protected Button startProcessInstanceButton;
    protected Button editProcessDefinitionButton;
    protected FormPropertiesForm processDefinitionStartForm;

    public ProcessDefinitionDetailPanel(String processDefinitionId, ProcessDefinitionPage processDefinitionPage) {
        super(processDefinitionId, processDefinitionPage);
    }

    @Override
    protected void initActions(AbstractPage parentPage) {
        ProcessDefinitionPage processDefinitionPage = (ProcessDefinitionPage)parentPage;
        this.startProcessInstanceButton = new Button(this.i18nManager.getMessage("process.start"));
        this.startProcessInstanceButton.addListener((Button.ClickListener)new StartProcessInstanceClickListener(this.processDefinition, processDefinitionPage));
        this.editProcessDefinitionButton = new Button(this.i18nManager.getMessage("process.convert"));
        this.editProcessDefinitionButton.addListener((Button.ClickListener)new ConvertProcessDefinitionToModelClickListener(this.processDefinition));
        if (!((ProcessDefinitionEntity)this.processDefinition).isGraphicalNotationDefined()) {
            this.editProcessDefinitionButton.setEnabled(false);
        }
        processDefinitionPage.getToolBar().removeAllButtons();
        processDefinitionPage.getToolBar().addButton(this.startProcessInstanceButton);
        processDefinitionPage.getToolBar().addButton(this.editProcessDefinitionButton);
    }

    public void showProcessStartForm(StartFormData startFormData) {
        if (this.processDefinitionStartForm == null) {
            this.processDefinitionStartForm = new FormPropertiesForm();
            this.processDefinitionStartForm.setSubmitButtonCaption(this.i18nManager.getMessage("process.start"));
            this.processDefinitionStartForm.setCancelButtonCaption(this.i18nManager.getMessage("button.cancel"));
            this.processDefinitionStartForm.addListener(new FormPropertiesEventListener(){
                private static final long serialVersionUID = 1L;

                @Override
                protected void handleFormSubmit(FormPropertiesForm.FormPropertiesEvent event) {
                    ProcessDefinitionDetailPanel.this.formService.submitStartFormData(ProcessDefinitionDetailPanel.this.processDefinition.getId(), event.getFormProperties());
                    ExplorerApp.get().getMainWindow().showNotification(MessageFormat.format(ProcessDefinitionDetailPanel.this.i18nManager.getMessage("process.started.notification"), ProcessDefinitionDetailPanel.this.getProcessDisplayName(ProcessDefinitionDetailPanel.this.processDefinition)));
                    ProcessDefinitionDetailPanel.this.initProcessDefinitionInfo();
                }

                @Override
                protected void handleFormCancel(FormPropertiesForm.FormPropertiesEvent event) {
                    ProcessDefinitionDetailPanel.this.initProcessDefinitionInfo();
                }
            });
        }
        this.processDefinitionStartForm.setFormProperties(startFormData.getFormProperties());
        this.startProcessInstanceButton.setEnabled(false);
        this.detailContainer.removeAllComponents();
        this.detailContainer.addComponent((Component)this.processDefinitionStartForm);
    }

    @Override
    public void initProcessDefinitionInfo() {
        super.initProcessDefinitionInfo();
        if (this.startProcessInstanceButton != null) {
            this.startProcessInstanceButton.setEnabled(true);
        }
    }
}

