/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.custom;

import com.vaadin.Application;
import com.vaadin.event.MouseEvents;
import com.vaadin.terminal.Resource;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.util.InputStreamStreamSource;

public class UserProfileLink
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    protected transient IdentityService identityService;
    protected ViewManager viewManager;

    public UserProfileLink(IdentityService identityService, boolean renderPicture, String userId) {
        this.identityService = identityService;
        this.viewManager = ExplorerApp.get().getViewManager();
        this.setSizeUndefined();
        this.setSpacing(true);
        this.addStyleName("profile-link");
        this.initPicture(identityService, renderPicture, userId);
        this.initUserLink(userId);
    }

    protected void initPicture(IdentityService identityService, boolean renderPicture, final String userName) {
        Picture picture;
        if (renderPicture && (picture = identityService.getUserPicture(userName)) != null) {
            StreamResource imageResource = new StreamResource((StreamResource.StreamSource)new InputStreamStreamSource(picture.getInputStream()), userName + picture.getMimeType(), (Application)ExplorerApp.get());
            Embedded image = new Embedded(null, (Resource)imageResource);
            image.addStyleName("clickable");
            image.setType(1);
            image.setHeight(30.0f, 0);
            image.setWidth(30.0f, 0);
            image.addListener(new MouseEvents.ClickListener(){
                private static final long serialVersionUID = 7341560240277898495L;

                public void click(MouseEvents.ClickEvent event) {
                    UserProfileLink.this.viewManager.showProfilePopup(userName);
                }
            });
            this.addComponent((Component)image);
            this.setComponentAlignment((Component)image, Alignment.MIDDLE_LEFT);
        }
    }

    protected void initUserLink(final String userId) {
        User user = (User)ProcessEngines.getDefaultProcessEngine().getIdentityService().createUserQuery().userId(userId).singleResult();
        Button userButton = new Button(user.getFirstName() + " " + user.getLastName());
        Button.ClickListener buttonClickListener = new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                UserProfileLink.this.viewManager.showProfilePopup(userId);
            }
        };
        userButton.addStyleName("link");
        userButton.addListener(buttonClickListener);
        this.addComponent((Component)userButton);
        this.setComponentAlignment((Component)userButton, Alignment.MIDDLE_LEFT);
    }
}

