/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.process.ProcessInstanceItem;

public class MyProcessInstancesListQuery
extends AbstractLazyLoadingQuery {
    protected transient HistoryService historyService;
    protected transient RepositoryService repositoryService;
    protected Map<String, ProcessDefinition> cachedProcessDefinitions;

    public MyProcessInstancesListQuery(HistoryService historyService, RepositoryService repositoryService) {
        this.historyService = historyService;
        this.repositoryService = repositoryService;
        this.cachedProcessDefinitions = new HashMap<String, ProcessDefinition>();
    }

    @Override
    public List<Item> loadItems(int start, int count) {
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().startedBy(ExplorerApp.get().getLoggedInUser().getId()).unfinished().list();
        ArrayList<Item> items = new ArrayList<Item>();
        for (HistoricProcessInstance processInstance : processInstances) {
            items.add((Item)this.createItem(processInstance));
        }
        return items;
    }

    @Override
    public Item loadSingleResult(String id) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().startedBy(ExplorerApp.get().getLoggedInUser().getId()).unfinished().processInstanceId(id).singleResult();
        if (processInstance != null) {
            return this.createItem(processInstance);
        }
        return null;
    }

    protected ProcessInstanceItem createItem(HistoricProcessInstance processInstance) {
        ProcessInstanceItem item = new ProcessInstanceItem();
        item.addItemProperty("id", (Property)new ObjectProperty((Object)processInstance.getId(), String.class));
        ProcessDefinition processDefinition = this.getProcessDefinition(processInstance.getProcessDefinitionId());
        String itemName = this.getProcessDisplayName(processDefinition) + " (" + processInstance.getId() + ")" + (processInstance.getBusinessKey() != null ? processInstance.getBusinessKey() : "");
        item.addItemProperty("name", (Property)new ObjectProperty((Object)itemName, String.class));
        return item;
    }

    protected String getProcessDisplayName(ProcessDefinition processDefinition) {
        if (processDefinition.getName() != null) {
            return processDefinition.getName();
        }
        return processDefinition.getKey();
    }

    protected ProcessDefinition getProcessDefinition(String id) {
        ProcessDefinition processDefinition = this.cachedProcessDefinitions.get(id);
        if (processDefinition == null) {
            processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
            this.cachedProcessDefinitions.put(id, processDefinition);
        }
        return processDefinition;
    }

    @Override
    public int size() {
        return (int)this.historyService.createHistoricProcessInstanceQuery().startedBy(ExplorerApp.get().getLoggedInUser().getId()).unfinished().count();
    }

    @Override
    public void setSorting(Object[] propertyId, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }
}

