/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DataAssociation;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.Process;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;
import org.apache.commons.lang3.StringUtils;

public class FlowElementValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof Activity)) continue;
            Activity activity = (Activity)flowElement;
            this.handleMultiInstanceLoopCharacteristics(process, activity, errors);
            this.handleDataAssociations(process, activity, errors);
        }
    }

    protected void handleMultiInstanceLoopCharacteristics(Process process, Activity activity, List<ValidationError> errors) {
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = activity.getLoopCharacteristics();
        if (multiInstanceLoopCharacteristics != null && StringUtils.isEmpty((CharSequence)multiInstanceLoopCharacteristics.getLoopCardinality()) && StringUtils.isEmpty((CharSequence)multiInstanceLoopCharacteristics.getInputDataItem())) {
            this.addError(errors, "activiti-multi-instance-missing-collection", process, (BaseElement)activity, "Either loopCardinality or loopDataInputRef/activiti:collection must been set");
        }
    }

    protected void handleDataAssociations(Process process, Activity activity, List<ValidationError> errors) {
        if (activity.getDataInputAssociations() != null) {
            for (DataAssociation dataAssociation : activity.getDataInputAssociations()) {
                if (!StringUtils.isEmpty((CharSequence)dataAssociation.getTargetRef())) continue;
                this.addError(errors, "activiti-data-association-missing-targetref", process, (BaseElement)activity, "Targetref is required on a data association");
            }
        }
        if (activity.getDataOutputAssociations() != null) {
            for (DataAssociation dataAssociation : activity.getDataOutputAssociations()) {
                if (!StringUtils.isEmpty((CharSequence)dataAssociation.getTargetRef())) continue;
                this.addError(errors, "activiti-data-association-missing-targetref", process, (BaseElement)activity, "Targetref is required on a data association");
            }
        }
    }
}

