/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.SubProcess;
import org.apache.commons.lang3.StringUtils;

public class BPMNDIExport
implements BpmnXMLConstants {
    public static void writeBPMNDI(BpmnModel model, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("bpmndi", "BPMNDiagram", "http://www.omg.org/spec/BPMN/20100524/DI");
        String processId = null;
        processId = model.getPools().size() > 0 ? "Collaboration" : model.getMainProcess().getId();
        xtw.writeAttribute("id", "BPMNDiagram_" + processId);
        xtw.writeStartElement("bpmndi", "BPMNPlane", "http://www.omg.org/spec/BPMN/20100524/DI");
        xtw.writeAttribute("bpmnElement", processId);
        xtw.writeAttribute("id", "BPMNPlane_" + processId);
        for (String elementId : model.getLocationMap().keySet()) {
            if (model.getFlowElement(elementId) == null && model.getArtifact(elementId) == null && model.getPool(elementId) == null && model.getLane(elementId) == null) continue;
            xtw.writeStartElement("bpmndi", "BPMNShape", "http://www.omg.org/spec/BPMN/20100524/DI");
            xtw.writeAttribute("bpmnElement", elementId);
            xtw.writeAttribute("id", "BPMNShape_" + elementId);
            GraphicInfo graphicInfo = model.getGraphicInfo(elementId);
            FlowElement flowElement = model.getFlowElement(elementId);
            if (flowElement instanceof SubProcess && graphicInfo.getExpanded() != null) {
                xtw.writeAttribute("isExpanded", String.valueOf(graphicInfo.getExpanded()));
            }
            xtw.writeStartElement("omgdc", "Bounds", "http://www.omg.org/spec/DD/20100524/DC");
            xtw.writeAttribute("height", "" + graphicInfo.getHeight());
            xtw.writeAttribute("width", "" + graphicInfo.getWidth());
            xtw.writeAttribute("x", "" + graphicInfo.getX());
            xtw.writeAttribute("y", "" + graphicInfo.getY());
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        for (String elementId : model.getFlowLocationMap().keySet()) {
            if (model.getFlowElement(elementId) == null && model.getArtifact(elementId) == null) continue;
            xtw.writeStartElement("bpmndi", "BPMNEdge", "http://www.omg.org/spec/BPMN/20100524/DI");
            xtw.writeAttribute("bpmnElement", elementId);
            xtw.writeAttribute("id", "BPMNEdge_" + elementId);
            List<GraphicInfo> graphicInfoList = model.getFlowLocationGraphicInfo(elementId);
            for (GraphicInfo graphicInfo : graphicInfoList) {
                xtw.writeStartElement("omgdi", "waypoint", "http://www.omg.org/spec/DD/20100524/DI");
                xtw.writeAttribute("x", "" + graphicInfo.getX());
                xtw.writeAttribute("y", "" + graphicInfo.getY());
                xtw.writeEndElement();
            }
            GraphicInfo labelGraphicInfo = model.getLabelGraphicInfo(elementId);
            FlowElement flowElement = model.getFlowElement(elementId);
            if (labelGraphicInfo != null && flowElement != null && StringUtils.isNotEmpty((CharSequence)flowElement.getName())) {
                xtw.writeStartElement("bpmndi", "BPMNLabel", "http://www.omg.org/spec/BPMN/20100524/DI");
                xtw.writeStartElement("omgdc", "Bounds", "http://www.omg.org/spec/DD/20100524/DC");
                xtw.writeAttribute("height", "" + labelGraphicInfo.getHeight());
                xtw.writeAttribute("width", "" + labelGraphicInfo.getWidth());
                xtw.writeAttribute("x", "" + labelGraphicInfo.getX());
                xtw.writeAttribute("y", "" + labelGraphicInfo.getY());
                xtw.writeEndElement();
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
        xtw.writeEndElement();
    }
}

