/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateThrowEventParseHandler
extends AbstractActivityBpmnParseHandler<ThrowEvent> {
    private static final Logger logger = LoggerFactory.getLogger(IntermediateThrowEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return ThrowEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, ThrowEvent intermediateEvent) {
        ActivityImpl nestedActivityImpl = this.createActivityOnCurrentScope(bpmnParse, intermediateEvent, "intermediateThrowEvent");
        EventDefinition eventDefinition = null;
        if (intermediateEvent.getEventDefinitions().size() > 0) {
            eventDefinition = intermediateEvent.getEventDefinitions().get(0);
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, eventDefinition);
        } else if (eventDefinition instanceof CompensateEventDefinition) {
            bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, eventDefinition);
        } else if (eventDefinition == null) {
            nestedActivityImpl.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createIntermediateThrowNoneEventActivityBehavior(intermediateEvent));
        } else {
            logger.warn("Unsupported intermediate throw event type for throw event " + intermediateEvent.getId());
        }
    }
}

