/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.AcquiredJobs;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.persistence.entity.JobEntity;

public class AcquireJobsCmd
implements Command<AcquiredJobs> {
    private final JobExecutor jobExecutor;

    public AcquireJobsCmd(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    @Override
    public AcquiredJobs execute(CommandContext commandContext) {
        String lockOwner = this.jobExecutor.getLockOwner();
        int lockTimeInMillis = this.jobExecutor.getLockTimeInMillis();
        int maxNonExclusiveJobsPerAcquisition = this.jobExecutor.getMaxJobsPerAcquisition();
        AcquiredJobs acquiredJobs = new AcquiredJobs();
        List<JobEntity> jobs = commandContext.getJobEntityManager().findNextJobsToExecute(new Page(0, maxNonExclusiveJobsPerAcquisition));
        for (JobEntity job : jobs) {
            ArrayList<String> jobIds = new ArrayList<String>();
            if (job != null && !acquiredJobs.contains(job.getId())) {
                if (job.isExclusive() && job.getProcessInstanceId() != null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    List<JobEntity> exclusiveJobs = commandContext.getJobEntityManager().findExclusiveJobsToExecute(job.getProcessInstanceId());
                    for (JobEntity exclusiveJob : exclusiveJobs) {
                        if (exclusiveJob == null) continue;
                        this.lockJob(commandContext, exclusiveJob, lockOwner, lockTimeInMillis);
                        jobIds.add(exclusiveJob.getId());
                    }
                } else {
                    this.lockJob(commandContext, job, lockOwner, lockTimeInMillis);
                    jobIds.add(job.getId());
                }
            }
            acquiredJobs.addJobIdBatch(jobIds);
        }
        return acquiredJobs;
    }

    protected void lockJob(CommandContext commandContext, JobEntity job, String lockOwner, int lockTimeInMillis) {
        job.setLockOwner(lockOwner);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }
}

