/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import org.activiti.engine.impl.cfg.TransactionListener;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailedJobListener
implements TransactionListener {
    private static final Logger log = LoggerFactory.getLogger(FailedJobListener.class);
    protected CommandExecutor commandExecutor;
    protected String jobId;
    protected Throwable exception;

    public FailedJobListener(CommandExecutor commandExecutor, String jobId, Throwable exception) {
        this.commandExecutor = commandExecutor;
        this.jobId = jobId;
        this.exception = exception;
    }

    @Override
    public void execute(CommandContext commandContext) {
        CommandConfig commandConfig = this.commandExecutor.getDefaultConfig().transactionRequiresNew();
        FailedJobCommandFactory failedJobCommandFactory = commandContext.getFailedJobCommandFactory();
        Command<Object> cmd = failedJobCommandFactory.getCommand(this.jobId, this.exception);
        log.trace("Using FailedJobCommandFactory '" + failedJobCommandFactory.getClass() + "' and command of type '" + cmd.getClass() + "'");
        this.commandExecutor.execute(commandConfig, cmd);
    }
}

