/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class EventSubprocessValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List<EventSubProcess> eventSubprocesses = process.findFlowElementsOfType(EventSubProcess.class);
        for (EventSubProcess eventSubprocess : eventSubprocesses) {
            List<StartEvent> startEvents = process.findFlowElementsInSubProcessOfType(eventSubprocess, StartEvent.class);
            for (StartEvent startEvent : startEvents) {
                EventDefinition eventDefinition;
                if (startEvent.getEventDefinitions() == null || startEvent.getEventDefinitions().size() <= 0 || (eventDefinition = startEvent.getEventDefinitions().get(0)) instanceof ErrorEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof SignalEventDefinition) continue;
                this.addError(errors, "activiti-event-subprocess-invalid-start-event-definition", process, eventSubprocess, "start event of event subprocess must be of type 'error', 'message' or 'signal'");
            }
        }
    }
}

