/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.Task;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public abstract class ExternalInvocationTaskValidator
extends ProcessLevelValidator {
    protected void validateFieldDeclarationsForEmail(Process process, Task task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean toDefined = false;
        boolean textOrHtmlDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            if (fieldExtension.getFieldName().equals("to")) {
                toDefined = true;
            }
            if (fieldExtension.getFieldName().equals("html")) {
                textOrHtmlDefined = true;
            }
            if (fieldExtension.getFieldName().equals("htmlVar")) {
                textOrHtmlDefined = true;
            }
            if (fieldExtension.getFieldName().equals("text")) {
                textOrHtmlDefined = true;
            }
            if (!fieldExtension.getFieldName().equals("textVar")) continue;
            textOrHtmlDefined = true;
        }
        if (!toDefined) {
            this.addError(errors, "activiti-mailtask-no-recipient", process, task, "No recipient is defined on the mail activity");
        }
        if (!textOrHtmlDefined) {
            this.addError(errors, "activiti-mailtask-no-content", process, task, "Text, html, textVar or htmlVar field should be provided");
        }
    }

    protected void validateFieldDeclarationsForShell(Process process, Task task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean shellCommandDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            String fieldName = fieldExtension.getFieldName();
            String fieldValue = fieldExtension.getStringValue();
            shellCommandDefined |= fieldName.equals("command");
            if (!fieldName.equals("wait") && !fieldName.equals("redirectError") && !fieldName.equals("cleanEnv") || fieldValue.toLowerCase().equals("true") || fieldValue.toLowerCase().equals("false")) continue;
            this.addError(errors, "activiti-shelltask-invalid-param", process, task, "Undefined parameter value for shell field");
        }
        if (!shellCommandDefined) {
            this.addError(errors, "activiti-shelltask-no-command", process, task, "No shell command is defined on the shell activity");
        }
    }
}

