/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class IntermediateCatchEventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List<IntermediateCatchEvent> intermediateCatchEvents = process.findFlowElementsOfType(IntermediateCatchEvent.class);
        for (IntermediateCatchEvent intermediateCatchEvent : intermediateCatchEvents) {
            EventDefinition eventDefinition = null;
            if (intermediateCatchEvent.getEventDefinitions().size() > 0) {
                eventDefinition = intermediateCatchEvent.getEventDefinitions().get(0);
            }
            if (eventDefinition == null) {
                this.addError(errors, "activiti-intermediate-catch-event-no-eventdefinition", process, intermediateCatchEvent, "No event definition for intermediate catch event ");
                continue;
            }
            if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof MessageEventDefinition) continue;
            this.addError(errors, "activiti-intermediate-catch-event-invalid-eventdefinition", process, intermediateCatchEvent, "Unsupported intermediate catch event type");
        }
    }
}

