/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Interface;
import org.activiti.bpmn.model.Operation;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ValidatorImpl;

public class OperationValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        if (bpmnModel.getInterfaces() != null) {
            for (Interface bpmnInterface : bpmnModel.getInterfaces()) {
                if (bpmnInterface.getOperations() == null) continue;
                for (Operation operation : bpmnInterface.getOperations()) {
                    if (bpmnModel.getMessage(operation.getInMessageRef()) != null) continue;
                    this.addError(errors, "activiti-operation-invalid-in-message-reference", null, operation, "Invalid inMessageRef for operation");
                }
            }
        }
    }
}

