/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class StartEventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List<StartEvent> startEvents = process.findFlowElementsOfType(StartEvent.class, false);
        ArrayList<StartEvent> nonMessageStartEvents = new ArrayList<StartEvent>();
        for (StartEvent startEvent : startEvents) {
            if (startEvent.getEventDefinitions() != null && startEvent.getEventDefinitions().size() > 0) {
                EventDefinition eventDefinition = startEvent.getEventDefinitions().get(0);
                if (eventDefinition instanceof MessageEventDefinition) continue;
                nonMessageStartEvents.add(startEvent);
                if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof SignalEventDefinition) continue;
                this.addError(errors, "activiti-start-event-invalid-event-definition", process, startEvent, "Unsupported event definition on start event");
                continue;
            }
            nonMessageStartEvents.add(startEvent);
        }
        if (nonMessageStartEvents.size() > 1) {
            for (StartEvent startEvent : nonMessageStartEvents) {
                this.addError(errors, "activiti-start-event-multiple-found", process, startEvent, "Multiple none start events or timer start events not supported on process definition");
            }
        }
    }
}

