/*
 * Decompiled with CFR 0.152.
 */
package alluxio.org.jets3t.service.io;

import alluxio.org.jets3t.service.io.OutputStreamWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class GZipInflatingOutputStream
extends OutputStream
implements OutputStreamWrapper {
    public static final int GZIP_MAGIC = 35615;
    private static final int FTEXT = 1;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private int BUFFER_SIZE = 8192;
    private Inflater inflater = new Inflater(true);
    private CRC32 crc = new CRC32();
    private OutputStream outputStream = null;
    private byte[] inflatedBytes = new byte[this.BUFFER_SIZE];
    private boolean finishedHeader = false;
    private byte[] headerBytes = new byte[156];
    private int expectedHeaderLength = 0;
    private int headerLength = 0;
    private int headerOffset = 0;
    private int headerFlag = 0;
    private byte[] trailerBytes = new byte[8];
    private int trailerOffset = 0;

    public GZipInflatingOutputStream(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        this.crc.reset();
        this.expectedHeaderLength = 4;
    }

    private void inflateData() throws IOException {
        try {
            int bytesWritten = -1;
            while (bytesWritten != 0) {
                bytesWritten = this.inflater.inflate(this.inflatedBytes, 0, this.inflatedBytes.length);
                this.outputStream.write(this.inflatedBytes, 0, bytesWritten);
                this.crc.update(this.inflatedBytes, 0, bytesWritten);
            }
        }
        catch (IOException e) {
            this.outputStream.close();
            throw e;
        }
        catch (DataFormatException e) {
            this.outputStream.close();
            throw new IOException("Invalid GZip data output stream: " + e);
        }
    }

    private void parseHeader(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len && this.headerLength < this.headerBytes.length; ++i) {
            this.headerBytes[this.headerLength++] = b[off + i];
        }
        if (this.headerOffset == 0 && this.headerLength >= 4) {
            int GZIP_MAGIC = 35615;
            if (this.bytesToShort(this.headerBytes, 0) != GZIP_MAGIC) {
                this.outputStream.close();
                throw new IOException("Not in GZIP format");
            }
            if ((this.headerBytes[2] & 0xFF) != 8) {
                this.outputStream.close();
                throw new IOException("Unexpected compression method");
            }
            this.headerFlag = this.headerBytes[3] & 0xFF;
            this.expectedHeaderLength += 6;
            this.headerOffset = 10;
            if ((this.headerFlag & 4) == 4) {
                this.expectedHeaderLength += 2;
            }
            if ((this.headerFlag & 8) == 8) {
                ++this.expectedHeaderLength;
            }
            if ((this.headerFlag & 0x10) == 16) {
                ++this.expectedHeaderLength;
            }
            if ((this.headerFlag & 2) == 2) {
                this.expectedHeaderLength += 2;
            }
        }
        while (this.headerOffset != this.expectedHeaderLength && this.headerLength >= this.expectedHeaderLength) {
            if ((this.headerFlag & 4) == 4) {
                int fieldLength = this.bytesToShort(this.headerBytes, this.headerOffset);
                this.expectedHeaderLength += fieldLength;
                this.headerOffset += 2 + fieldLength;
                continue;
            }
            if ((this.headerFlag & 8) == 8) {
                char fnameChar;
                if ((fnameChar = (char)this.headerBytes[this.headerOffset++]) == '\u0000') continue;
                ++this.expectedHeaderLength;
                continue;
            }
            if ((this.headerFlag & 0x10) == 16) {
                while ((this.headerBytes[this.headerOffset] & 0xFF) != 0) {
                    ++this.headerOffset;
                    ++this.expectedHeaderLength;
                }
                continue;
            }
            if ((this.headerFlag & 2) != 2) continue;
            this.crc.update(this.headerBytes, 0, this.headerOffset);
            int v = (int)this.crc.getValue() & 0xFFFF;
            if (this.bytesToShort(this.headerBytes, this.headerOffset) != v) {
                this.outputStream.close();
                throw new IOException("Corrupt GZIP header");
            }
            this.crc.reset();
            ++this.headerOffset;
            ++this.expectedHeaderLength;
        }
        if (this.headerOffset == this.expectedHeaderLength && this.headerLength >= this.expectedHeaderLength) {
            this.finishedHeader = true;
            if (this.headerLength > this.headerOffset) {
                this.inflater.setInput(this.headerBytes, this.headerOffset, this.headerLength - this.headerOffset);
            }
            if (len > this.headerLength) {
                this.inflater.setInput(b, this.headerOffset, len - this.headerOffset);
            }
        }
    }

    public void write(int value) throws IOException {
        byte[] single = new byte[]{(byte)(value & 0xFF)};
        this.write(single, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (!this.finishedHeader) {
            this.parseHeader(b, off, len);
        } else {
            this.inflater.setInput(b, off, len);
        }
        if (!this.inflater.finished()) {
            this.inflateData();
            if (this.inflater.finished() && this.inflater.getRemaining() > 0) {
                int trailerOffsetInInput = len - this.inflater.getRemaining();
                while (this.trailerOffset < this.inflater.getRemaining()) {
                    this.trailerBytes[this.trailerOffset++] = b[trailerOffsetInInput++];
                }
            }
        } else {
            if (this.trailerOffset + len > this.trailerBytes.length) {
                this.outputStream.close();
                throw new IOException("Corrupt GZIP trailer, too many trailer bytes (only 8 expected)");
            }
            System.arraycopy(b, off, this.trailerBytes, this.trailerOffset, len);
            this.trailerOffset += len;
        }
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void close() throws IOException {
        this.outputStream.close();
        if (this.inflater != null) {
            if (this.trailerOffset < this.trailerBytes.length) {
                throw new IOException("Corrupt GZIP trailer, trailer is incomplete. Expected 8 bytes, only have " + this.trailerOffset);
            }
            long trailerCrc = this.bytesToInt(this.trailerBytes, 0);
            if (trailerCrc != this.crc.getValue()) {
                throw new IOException("Corrupt GZIP trailer, CRC values mismatch");
            }
            long trailerByteCount = this.bytesToInt(this.trailerBytes, 4);
            if (trailerByteCount != (long)this.inflater.getTotalOut()) {
                throw new IOException("Corrupt GZIP trailer, actual size of inflated data mismatch");
            }
            this.inflater.end();
            this.inflater = null;
        }
    }

    private int bytesToShort(byte[] b, int offset) {
        int low = b[offset] & 0xFF;
        int high = b[offset + 1] & 0xFF;
        return high << 8 | low;
    }

    private long bytesToInt(byte[] b, int offset) {
        int low = this.bytesToShort(b, offset);
        int high = this.bytesToShort(b, offset + 2);
        return (long)high << 16 | (long)low;
    }

    public OutputStream getWrappedOutputStream() {
        return this.outputStream;
    }
}

