/*
 * Decompiled with CFR 0.152.
 */
package alluxio.org.jets3t.service.io;

import alluxio.org.jets3t.service.io.RepeatableFileInputStream;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SegmentedRepeatableFileInputStream
extends RepeatableFileInputStream {
    private static final Log log = LogFactory.getLog(SegmentedRepeatableFileInputStream.class);
    protected long offset = 0L;
    protected long segmentLength = 0L;

    public SegmentedRepeatableFileInputStream(File file, long offset, long segmentLength) throws IOException {
        super(file);
        this.offset = offset;
        this.segmentLength = segmentLength;
        if (segmentLength < 1L) {
            throw new IllegalArgumentException("Segment length " + segmentLength + " must be greater than 0");
        }
        if (file.length() < this.offset + this.segmentLength) {
            throw new IllegalArgumentException("Offset " + offset + " plus segment length " + segmentLength + "exceed length of file " + file);
        }
        this.skipToOffset();
    }

    private void skipToOffset() throws IOException {
        long skipped = 0L;
        for (long toSkip = this.offset; toSkip > 0L; toSkip -= skipped) {
            skipped = this.skip(toSkip);
        }
        super.mark(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Skipped to segment offset " + this.offset));
        }
    }

    public int available() throws IOException {
        long reallyAvailable = this.segmentLength - (this.bytesReadPastMarkPoint + this.getRelativeMarkPoint());
        if (reallyAvailable > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)reallyAvailable;
    }

    public int read() throws IOException {
        if (this.bytesReadPastMarkPoint + this.getRelativeMarkPoint() >= this.segmentLength) {
            return -1;
        }
        return super.read();
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        this.bytesReadPastMarkPoint += (long)off;
        if (this.bytesReadPastMarkPoint + this.getRelativeMarkPoint() >= this.segmentLength) {
            return -1;
        }
        if (this.bytesReadPastMarkPoint + this.getRelativeMarkPoint() + (long)len > this.segmentLength) {
            len = (int)(this.segmentLength - (this.bytesReadPastMarkPoint + this.getRelativeMarkPoint() + (long)off));
        }
        return super.read(bytes, off, len);
    }

    private long getRelativeMarkPoint() {
        return this.markPoint - this.offset;
    }
}

