/*
 * Decompiled with CFR 0.152.
 */
package alluxio.org.jets3t.service.model;

import alluxio.org.jets3t.service.acl.AccessControlList;
import alluxio.org.jets3t.service.model.S3Bucket;
import alluxio.org.jets3t.service.model.StorageObject;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class S3Object
extends StorageObject
implements Cloneable {
    public static final String STORAGE_CLASS_STANDARD = "STANDARD";
    public static final String STORAGE_CLASS_REDUCED_REDUNDANCY = "REDUCED_REDUNDANCY";
    public static final String S3_VERSION_ID = "version-id";

    public S3Object(S3Bucket bucket, File file) throws NoSuchAlgorithmException, IOException {
        super(file);
        if (bucket != null) {
            this.bucketName = bucket.getName();
        }
    }

    public S3Object(File file) throws NoSuchAlgorithmException, IOException {
        super(file);
    }

    public S3Object(S3Bucket bucket, String key, String dataString) throws NoSuchAlgorithmException, IOException {
        super(key, dataString);
        if (bucket != null) {
            this.bucketName = bucket.getName();
        }
    }

    public S3Object(String key, String dataString) throws NoSuchAlgorithmException, IOException {
        super(key, dataString);
    }

    public S3Object(String key, byte[] data) throws NoSuchAlgorithmException, IOException {
        super(key, data);
    }

    public S3Object(String key) {
        super(key);
    }

    public S3Object(S3Bucket bucket, String key) {
        super(key);
        if (bucket != null) {
            this.bucketName = bucket.getName();
        }
    }

    public S3Object() {
    }

    public String toString() {
        return "S3Object [key=" + this.getKey() + ", bucket=" + (this.bucketName == null ? "<Unknown>" : this.bucketName) + ", lastModified=" + this.getLastModifiedDate() + ", dataInputStream=" + this.dataInputStream + (this.getStorageClass() != null ? ", storageClass=" + this.getStorageClass() : "") + ", Metadata=" + this.getMetadataMap() + "]";
    }

    public void setAcl(AccessControlList acl) {
        String restHeaderAclValue;
        this.acl = acl;
        if (acl != null && (restHeaderAclValue = acl.getValueForRESTHeaderACL()) != null) {
            this.addMetadata("x-amz-acl", restHeaderAclValue);
        }
    }

    public String getVersionId() {
        return (String)this.getMetadata(S3_VERSION_ID);
    }

    public Object clone() {
        S3Object clone = new S3Object(this.getKey());
        clone.bucketName = this.bucketName;
        clone.dataInputStream = this.dataInputStream;
        clone.acl = this.acl;
        clone.isMetadataComplete = this.isMetadataComplete;
        clone.dataInputFile = this.dataInputFile;
        clone.storageClass = this.storageClass;
        clone.setOwner(this.getOwner());
        clone.addAllMetadata(this.getMetadataMap());
        return clone;
    }

    public static S3Object[] cast(StorageObject[] objects) {
        ArrayList<S3Object> results = new ArrayList<S3Object>();
        for (StorageObject object : objects) {
            results.add((S3Object)object);
        }
        return results.toArray(new S3Object[results.size()]);
    }
}

