/*
 * Decompiled with CFR 0.152.
 */
package alluxio.org.jets3t.service.multi.event;

import alluxio.org.jets3t.service.model.StorageObject;
import alluxio.org.jets3t.service.multi.ThreadWatcher;
import alluxio.org.jets3t.service.multi.event.ServiceEvent;

public class GetObjectsEvent
extends ServiceEvent {
    private StorageObject[] objects = null;

    private GetObjectsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static GetObjectsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        GetObjectsEvent event = new GetObjectsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static GetObjectsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        GetObjectsEvent event = new GetObjectsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static GetObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, StorageObject[] completedObjects, Object uniqueOperationId) {
        GetObjectsEvent event = new GetObjectsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static GetObjectsEvent newCompletedEvent(Object uniqueOperationId) {
        GetObjectsEvent event = new GetObjectsEvent(2, uniqueOperationId);
        return event;
    }

    public static GetObjectsEvent newCancelledEvent(StorageObject[] incompletedObjects, Object uniqueOperationId) {
        GetObjectsEvent event = new GetObjectsEvent(4, uniqueOperationId);
        event.setObjects(incompletedObjects);
        return event;
    }

    public static GetObjectsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        GetObjectsEvent event = new GetObjectsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(StorageObject[] objects) {
        this.objects = objects;
    }

    public StorageObject[] getCompletedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Completed Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public StorageObject[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

