/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.org.jets3t.service.ServiceException;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.gcs.GCSUnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GCSUnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    public UnderFileSystem create(String path, Object unusedConf) {
        Preconditions.checkNotNull((Object)path);
        if (this.addAndCheckGoogleCredentials()) {
            try {
                return new GCSUnderFileSystem(new AlluxioURI(path));
            }
            catch (ServiceException e) {
                LOG.error("Failed to create GCSUnderFileSystem.", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "Google Credentials not available, cannot create GCS Under File System.";
        LOG.error(err);
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("gs://");
    }

    private boolean addAndCheckGoogleCredentials() {
        String secretKeyConf;
        String accessKeyConf = "fs.gcs.accessKeyId";
        if (System.getProperty(accessKeyConf) != null && !Configuration.containsKey((String)accessKeyConf)) {
            Configuration.set((String)accessKeyConf, (String)System.getProperty(accessKeyConf));
        }
        if (System.getProperty(secretKeyConf = "fs.gcs.secretAccessKey") != null && !Configuration.containsKey((String)secretKeyConf)) {
            Configuration.set((String)secretKeyConf, (String)System.getProperty(secretKeyConf));
        }
        return Configuration.containsKey((String)accessKeyConf) && Configuration.containsKey((String)secretKeyConf);
    }
}

