/*
 * Decompiled with CFR 0.152.
 */
package alluxio.org.jets3t.service.impl.rest;

import alluxio.org.jets3t.service.acl.Permission;
import alluxio.org.jets3t.service.acl.gs.AllAuthenticatedUsersGrantee;
import alluxio.org.jets3t.service.acl.gs.AllUsersGrantee;
import alluxio.org.jets3t.service.acl.gs.GSAccessControlList;
import alluxio.org.jets3t.service.acl.gs.GroupByDomainGrantee;
import alluxio.org.jets3t.service.acl.gs.GroupByEmailAddressGrantee;
import alluxio.org.jets3t.service.acl.gs.GroupByIdGrantee;
import alluxio.org.jets3t.service.acl.gs.UserByEmailAddressGrantee;
import alluxio.org.jets3t.service.acl.gs.UserByIdGrantee;
import alluxio.org.jets3t.service.impl.rest.AccessControlListHandler;
import alluxio.org.jets3t.service.model.GSOwner;
import org.xml.sax.Attributes;

public class GSAccessControlListHandler
extends AccessControlListHandler {
    protected String scopeType = null;

    public void startElement(String name, Attributes attrs) {
        if (name.equals("Owner")) {
            this.owner = new GSOwner();
        } else if (name.equals("Entries")) {
            this.accessControlList = new GSAccessControlList();
            this.accessControlList.setOwner(this.owner);
            this.insideACL = true;
        } else if (name.equals("Scope")) {
            this.scopeType = attrs.getValue("type");
            if (this.scopeType.equals("UserById")) {
                this.currentGrantee = new UserByIdGrantee();
            } else if (this.scopeType.equals("UserByEmail")) {
                this.currentGrantee = new UserByEmailAddressGrantee();
            } else if (this.scopeType.equals("GroupById")) {
                this.currentGrantee = new GroupByIdGrantee();
            } else if (this.scopeType.equals("GroupByEmail")) {
                this.currentGrantee = new GroupByEmailAddressGrantee();
            } else if (this.scopeType.equals("GroupByDomain")) {
                this.currentGrantee = new GroupByDomainGrantee();
            } else if (this.scopeType.equals("AllUsers")) {
                this.currentGrantee = new AllUsersGrantee();
            } else if (this.scopeType.equals("AllAuthenticatedUsers")) {
                this.currentGrantee = new AllAuthenticatedUsersGrantee();
            }
        }
    }

    public void endElement(String name, String elementText) {
        if (name.equals("ID") && !this.insideACL) {
            this.owner.setId(elementText);
        } else if (name.equals("Name") && !this.insideACL) {
            this.owner.setDisplayName(elementText);
        } else if (name.equals("ID")) {
            this.currentGrantee.setIdentifier(elementText);
        } else if (name.equals("EmailAddress")) {
            this.currentGrantee.setIdentifier(elementText);
        } else if (name.equals("URI")) {
            this.currentGrantee.setIdentifier(elementText);
        } else if (name.equals("Name")) {
            if (this.currentGrantee instanceof UserByIdGrantee) {
                ((UserByIdGrantee)this.currentGrantee).setName(elementText);
            } else if (this.currentGrantee instanceof UserByEmailAddressGrantee) {
                ((UserByEmailAddressGrantee)this.currentGrantee).setName(elementText);
            } else if (this.currentGrantee instanceof GroupByIdGrantee) {
                ((GroupByIdGrantee)this.currentGrantee).setName(elementText);
            } else if (this.currentGrantee instanceof GroupByEmailAddressGrantee) {
                ((GroupByEmailAddressGrantee)this.currentGrantee).setName(elementText);
            }
        } else if (name.equals("Permission")) {
            this.currentPermission = Permission.parsePermission(elementText);
        } else if (name.equals("Entry")) {
            this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
        } else if (name.equals("Entries")) {
            this.insideACL = false;
        }
    }
}

