/*
 * Decompiled with CFR 0.152.
 */
package alluxio.org.jets3t.service.io;

import alluxio.org.jets3t.service.io.InputStreamWrapper;
import alluxio.org.jets3t.service.io.UnrecoverableIOException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InterruptableInputStream
extends InputStream
implements InputStreamWrapper {
    private static final Log log = LogFactory.getLog(InterruptableInputStream.class);
    private InputStream inputStream = null;
    private boolean interrupted = false;

    public InterruptableInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    private void maybeInterruptInputStream() throws IOException {
        if (this.interrupted) {
            block4: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Input stream interrupted, closing underlying input stream " + this.inputStream.getClass()));
                }
                try {
                    this.close();
                }
                catch (IOException ioe) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)"Unable to close underlying InputStream on interrupt");
                }
            }
            throw new UnrecoverableIOException("Reading from input stream deliberately interrupted");
        }
    }

    public int read() throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.read(b, off, len);
    }

    public int available() throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }

    public void interrupt() {
        this.interrupted = true;
    }
}

