/*
 * Decompiled with CFR 0.152.
 */
package alluxio.org.jets3t.service.utils;

import alluxio.org.jets3t.service.S3Service;
import alluxio.org.jets3t.service.ServiceException;
import alluxio.org.jets3t.service.io.SegmentedRepeatableFileInputStream;
import alluxio.org.jets3t.service.model.MultipartUpload;
import alluxio.org.jets3t.service.model.S3Object;
import alluxio.org.jets3t.service.model.StorageObject;
import alluxio.org.jets3t.service.multi.StorageServiceEventListener;
import alluxio.org.jets3t.service.multi.s3.MultipartStartsEvent;
import alluxio.org.jets3t.service.multi.s3.MultipartUploadAndParts;
import alluxio.org.jets3t.service.multi.s3.S3ServiceEventAdaptor;
import alluxio.org.jets3t.service.multi.s3.S3ServiceEventListener;
import alluxio.org.jets3t.service.multi.s3.ThreadedS3Service;
import alluxio.org.jets3t.service.utils.ServiceUtils;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartUtils {
    private static final Log log = LogFactory.getLog(MultipartUtils.class);
    public static final long MIN_PART_SIZE = 0x500000L;
    public static final long MAX_OBJECT_SIZE = 0x40000000L;
    protected long maxPartSize = 0x40000000L;

    public MultipartUtils(long maxPartSize) {
        if (maxPartSize < 0x500000L) {
            throw new IllegalArgumentException("Maximum part size parameter " + maxPartSize + " is less than the minimum legal part size " + 0x500000L);
        }
        if (maxPartSize > 0x40000000L) {
            throw new IllegalArgumentException("Maximum part size parameter " + maxPartSize + " is greater than the maximum legal upload object size " + 0x40000000L);
        }
        this.maxPartSize = maxPartSize;
    }

    public MultipartUtils() {
    }

    public long getMaxPartSize() {
        return this.maxPartSize;
    }

    public boolean isFileLargerThanMaxPartSize(File file) {
        return file.length() > this.maxPartSize;
    }

    public List<S3Object> splitFileIntoObjectsByMaxPartSize(String objectKey, File file) throws IOException, NoSuchAlgorithmException {
        long fileLength = file.length();
        long partCount = fileLength / this.maxPartSize + (long)(fileLength % this.maxPartSize > 0L ? 1 : 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Splitting file " + file.getAbsolutePath() + " of " + fileLength + " bytes into " + partCount + " object parts with a maximum part size of " + this.maxPartSize));
        }
        ArrayList<S3Object> multipartPartList = new ArrayList<S3Object>();
        SegmentedRepeatableFileInputStream segFIS = null;
        for (long offset = 0L; offset < partCount; ++offset) {
            S3Object object = new S3Object(objectKey);
            if (offset < partCount - 1L) {
                object.setContentLength(this.maxPartSize);
                segFIS = new SegmentedRepeatableFileInputStream(file, offset * this.maxPartSize, this.maxPartSize);
            } else {
                long partLength = fileLength % this.maxPartSize;
                if (partLength == 0L) {
                    partLength = this.maxPartSize;
                }
                object.setContentLength(partLength);
                segFIS = new SegmentedRepeatableFileInputStream(file, offset * this.maxPartSize, partLength);
            }
            object.setContentLength(segFIS.available());
            object.setDataInputStream(segFIS);
            object.setMd5Hash(ServiceUtils.computeMD5Hash(segFIS));
            segFIS.reset();
            multipartPartList.add(object);
        }
        return multipartPartList;
    }

    public void uploadObjects(String bucketName, S3Service s3Service, List<StorageObject> objectsForMultipartUpload, S3ServiceEventListener eventListener) throws Exception {
        if (objectsForMultipartUpload == null || objectsForMultipartUpload.size() < 1) {
            return;
        }
        final ArrayList<MultipartUpload> multipartUploadList = new ArrayList<MultipartUpload>();
        ArrayList<MultipartUploadAndParts> uploadAndPartsList = new ArrayList<MultipartUploadAndParts>();
        if (eventListener == null) {
            eventListener = new S3ServiceEventAdaptor();
        }
        S3ServiceEventAdaptor captureMultipartUploadObjectsEventAdaptor = new S3ServiceEventAdaptor(){

            public void event(MultipartStartsEvent event) {
                if (3 == event.getEventCode()) {
                    for (MultipartUpload upload : event.getStartedUploads()) {
                        multipartUploadList.add(upload);
                    }
                }
            }
        };
        try {
            ThreadedS3Service threadedS3Service = new ThreadedS3Service(s3Service, (StorageServiceEventListener)eventListener);
            threadedS3Service.addServiceEventListener(captureMultipartUploadObjectsEventAdaptor);
            HashMap<String, StorageObject> objectsByKey = new HashMap<String, StorageObject>();
            for (StorageObject object : objectsForMultipartUpload) {
                objectsByKey.put(object.getKey(), object);
            }
            threadedS3Service.multipartStartUploads(bucketName, objectsForMultipartUpload);
            this.throwServiceEventAdaptorErrorIfPresent(eventListener);
            for (MultipartUpload upload : multipartUploadList) {
                StorageObject object = (StorageObject)objectsByKey.get(upload.getObjectKey());
                if (object.getDataInputFile() == null) {
                    throw new ServiceException();
                }
                List<S3Object> partObjects = this.splitFileIntoObjectsByMaxPartSize(upload.getObjectKey(), object.getDataInputFile());
                uploadAndPartsList.add(new MultipartUploadAndParts(upload, partObjects));
            }
            threadedS3Service.multipartUploadParts(uploadAndPartsList);
            this.throwServiceEventAdaptorErrorIfPresent(eventListener);
            threadedS3Service.multipartCompleteUploads(multipartUploadList);
            this.throwServiceEventAdaptorErrorIfPresent(eventListener);
        }
        catch (Exception e) {
            throw new Exception("Multipart upload failed", e);
        }
    }

    protected void throwServiceEventAdaptorErrorIfPresent(S3ServiceEventListener eventListener) throws Exception {
        if (eventListener instanceof S3ServiceEventAdaptor) {
            ((S3ServiceEventAdaptor)eventListener).throwErrorIfPresent();
        }
    }
}

