/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.archiva.dependency.graph.DependencyGraphKeys;
import org.apache.maven.archiva.model.ArtifactReference;
import org.apache.maven.archiva.model.Dependency;
import org.apache.maven.archiva.model.Exclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraphNode {
    private ArtifactReference artifact;
    private List<Dependency> dependencyManagement = new ArrayList<Dependency>();
    private Set<String> excludes = new HashSet<String>();
    private boolean resolved = false;
    private boolean fromParent = false;
    private boolean conflicted = false;

    public DependencyGraphNode(ArtifactReference artifact) {
        this.artifact = artifact;
    }

    public void addExclude(Exclusion exclusion) {
        this.excludes.add(DependencyGraphKeys.toManagementKey(exclusion));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyGraphNode other = (DependencyGraphNode)obj;
        return !(this.artifact == null ? other.artifact != null : !this.artifact.equals((Object)other.artifact));
    }

    public ArtifactReference getArtifact() {
        return this.artifact;
    }

    public List<Dependency> getDependencyManagement() {
        return this.dependencyManagement;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.artifact == null ? 0 : this.artifact.hashCode());
        return result;
    }

    public boolean isConflicted() {
        return this.conflicted;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void addDependencyManagement(Dependency dep) {
        this.dependencyManagement.add(dep);
    }

    public void setArtifact(ArtifactReference artifact) {
        this.artifact = artifact;
    }

    public void setConflicted(boolean conflicted) {
        this.conflicted = conflicted;
    }

    public void setDependencyManagement(List<Dependency> dependencyManagement) {
        this.dependencyManagement = dependencyManagement;
    }

    public void setExcludes(Set<String> excludes) {
        this.excludes = excludes;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public String toString() {
        return DependencyGraphKeys.toKey(this.artifact);
    }

    public boolean isFromParent() {
        return this.fromParent;
    }

    public void setFromParent(boolean fromParent) {
        this.fromParent = fromParent;
    }
}

