/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.dependency.graph.DependencyGraph;
import org.apache.maven.archiva.dependency.graph.DependencyGraphEdge;
import org.apache.maven.archiva.dependency.graph.DependencyGraphKeys;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.dependency.graph.functors.NodePredicate;
import org.apache.maven.archiva.dependency.graph.functors.OrphanedNodePredicate;
import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.ArtifactReference;
import org.apache.maven.archiva.model.Dependency;
import org.apache.maven.archiva.model.Exclusion;
import org.apache.maven.archiva.model.VersionedReference;

public class DependencyGraphUtils {
    public static void addNodeFromModel(ArchivaProjectModel model, DependencyGraph graph, DependencyGraphNode fromNode) {
        if (model == null) {
            throw new IllegalStateException("Unable to add null model for " + DependencyGraphKeys.toKey(fromNode.getArtifact()));
        }
        if (model.getRelocation() != null) {
            ArtifactReference refTO = new ArtifactReference();
            refTO.setGroupId(fromNode.getArtifact().getGroupId());
            refTO.setArtifactId(fromNode.getArtifact().getArtifactId());
            refTO.setVersion(fromNode.getArtifact().getVersion());
            refTO.setClassifier(fromNode.getArtifact().getClassifier());
            refTO.setType(fromNode.getArtifact().getType());
            VersionedReference relocation = model.getRelocation();
            if (StringUtils.isNotBlank((String)relocation.getGroupId())) {
                refTO.setGroupId(relocation.getGroupId());
            }
            if (StringUtils.isNotBlank((String)relocation.getArtifactId())) {
                refTO.setArtifactId(relocation.getArtifactId());
            }
            if (StringUtils.isNotBlank((String)relocation.getVersion())) {
                refTO.setVersion(relocation.getVersion());
            }
            DependencyGraphNode nodeTO = new DependencyGraphNode(refTO);
            graph.addNode(nodeTO);
            DependencyGraphUtils.collapseNodes(graph, fromNode, nodeTO);
            return;
        }
        boolean isRootNode = graph.getRootNode().equals(fromNode);
        if (CollectionUtils.isNotEmpty((Collection)model.getDependencyManagement())) {
            for (Dependency dependency : model.getDependencyManagement()) {
                fromNode.addDependencyManagement(dependency);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)model.getDependencies())) {
            for (Dependency dependency : model.getDependencies()) {
                String scope = dependency.getScope();
                if ("test".equals(scope) && !isRootNode) continue;
                ArtifactReference artifactRef = new ArtifactReference();
                artifactRef.setGroupId(dependency.getGroupId());
                artifactRef.setArtifactId(dependency.getArtifactId());
                artifactRef.setVersion(dependency.getVersion());
                artifactRef.setClassifier(dependency.getClassifier());
                artifactRef.setType(dependency.getType());
                DependencyGraphNode toNode = new DependencyGraphNode(artifactRef);
                if (CollectionUtils.isNotEmpty((Collection)dependency.getExclusions())) {
                    for (Exclusion exclusion : dependency.getExclusions()) {
                        toNode.addExclude(exclusion);
                    }
                }
                if (dependency.isFromParent()) {
                    toNode.setFromParent(true);
                }
                graph.addNode(toNode);
                DependencyGraphEdge edge = new DependencyGraphEdge(fromNode.getArtifact(), toNode.getArtifact());
                edge.setScope(StringUtils.defaultIfEmpty((String)dependency.getScope(), (String)"compile"));
                if (dependency.isOptional()) {
                    edge.setDisabled(true);
                    edge.setDisabledType(2);
                    edge.setDisabledReason("Optional Dependency");
                }
                graph.addEdge(edge);
            }
        }
        fromNode.setResolved(true);
        graph.addNode(fromNode);
    }

    public static void cleanupOrphanedNodes(DependencyGraph graph) {
        boolean done = false;
        OrphanedNodePredicate orphanedNodePredicate = new OrphanedNodePredicate(graph);
        Predicate notRootNode = NotPredicate.getInstance((Predicate)new NodePredicate(graph.getRootNode().getArtifact()));
        Predicate orphanedChildNodePredicate = AndPredicate.getInstance((Predicate)notRootNode, (Predicate)orphanedNodePredicate);
        while (!done) {
            DependencyGraphNode orphanedNode = (DependencyGraphNode)CollectionUtils.find(graph.getNodes(), (Predicate)orphanedChildNodePredicate);
            if (orphanedNode == null) {
                done = true;
                break;
            }
            for (DependencyGraphEdge edge : graph.getEdgesFrom(orphanedNode)) {
                graph.removeEdge(edge);
            }
            graph.removeNode(orphanedNode);
        }
    }

    public static void collapseNodes(DependencyGraph graph, DependencyGraphNode nodeFROM, DependencyGraphNode nodeTO) {
        HashSet<DependencyGraphEdge> edgesToRemove = new HashSet<DependencyGraphEdge>();
        List<DependencyGraphEdge> fromEdges = graph.getEdgesFrom(nodeFROM);
        if (CollectionUtils.isNotEmpty(fromEdges)) {
            edgesToRemove.addAll(fromEdges);
        }
        List<DependencyGraphEdge> toEdges = graph.getEdgesTo(nodeFROM);
        for (DependencyGraphEdge edge : toEdges) {
            edgesToRemove.add(edge);
            DependencyGraphEdge newedge = DependencyGraphUtils.clone(edge);
            newedge.setNodeTo(nodeTO);
            graph.addEdge(newedge);
        }
        for (DependencyGraphEdge edge : edgesToRemove) {
            graph.removeEdge(edge);
        }
        graph.removeNode(nodeFROM);
    }

    public static DependencyGraphEdge clone(DependencyGraphEdge edge) {
        DependencyGraphEdge cloned = new DependencyGraphEdge(edge.getNodeFrom(), edge.getNodeTo());
        cloned.setDisabled(edge.isDisabled());
        cloned.setDisabledReason(edge.getDisabledReason());
        cloned.setDisabledType(edge.getDisabledType());
        cloned.setScope(edge.getScope());
        return cloned;
    }
}

