/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.common.filelock;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.archiva.common.filelock.FileLockException;
import org.apache.archiva.common.filelock.FileLockManager;
import org.apache.archiva.common.filelock.FileLockTimeoutException;
import org.apache.archiva.common.filelock.Lock;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="fileLockManager#default")
public class DefaultFileLockManager
implements FileLockManager {
    private static final ConcurrentMap<File, Lock> lockFiles = new ConcurrentHashMap<File, Lock>(64);
    private boolean skipLocking = true;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private int timeout = 0;

    @Override
    public Lock readFileLock(File file) throws FileLockException, FileLockTimeoutException {
        Lock current;
        if (this.skipLocking) {
            return new Lock(file);
        }
        StopWatch stopWatch = new StopWatch();
        boolean acquired = false;
        this.mkdirs(file.getParentFile());
        Lock lock = null;
        stopWatch.start();
        while (!acquired) {
            if (this.timeout > 0) {
                long delta = stopWatch.getTime();
                this.log.debug("delta {}, timeout {}", (Object)delta, (Object)this.timeout);
                if (delta > (long)this.timeout) {
                    this.log.warn("Cannot acquire read lock within {} millis. Will skip the file: {}", (Object)this.timeout, (Object)file);
                    throw new FileLockTimeoutException();
                }
            }
            if ((current = (Lock)lockFiles.get(file)) != null) {
                this.log.debug("read lock file exist continue wait");
                continue;
            }
            try {
                lock = new Lock(file, false);
                this.createNewFileQuietly(file);
                lock.openLock(false, this.timeout > 0);
                acquired = true;
            }
            catch (FileNotFoundException e) {
                if (lock != null) {
                    this.closeQuietly(lock.getRandomAccessFile());
                }
                this.log.debug("read Lock skip: {} try to create file", (Object)e.getMessage());
                this.createNewFileQuietly(file);
            }
            catch (IOException e) {
                throw new FileLockException(e.getMessage(), e);
            }
            catch (IllegalStateException e) {
                this.log.debug("openLock {}:{}", e.getClass(), (Object)e.getMessage());
            }
        }
        current = lockFiles.putIfAbsent(file, lock);
        if (current != null) {
            lock = current;
        }
        return lock;
    }

    @Override
    public Lock writeFileLock(File file) throws FileLockException, FileLockTimeoutException {
        Lock current;
        if (this.skipLocking) {
            return new Lock(file);
        }
        this.mkdirs(file.getParentFile());
        StopWatch stopWatch = new StopWatch();
        boolean acquired = false;
        Lock lock = null;
        stopWatch.start();
        while (!acquired) {
            if (this.timeout > 0) {
                long delta = stopWatch.getTime();
                this.log.debug("delta {}, timeout {}", (Object)delta, (Object)this.timeout);
                if (delta > (long)this.timeout) {
                    this.log.warn("Cannot acquire read lock within {} millis. Will skip the file: {}", (Object)this.timeout, (Object)file);
                    throw new FileLockTimeoutException();
                }
            }
            current = (Lock)lockFiles.get(file);
            try {
                if (current != null) {
                    this.log.debug("write lock file exist continue wait");
                    continue;
                }
                lock = new Lock(file, true);
                this.createNewFileQuietly(file);
                lock.openLock(true, this.timeout > 0);
                acquired = true;
            }
            catch (FileNotFoundException e) {
                if (lock != null) {
                    this.closeQuietly(lock.getRandomAccessFile());
                }
                this.log.debug("write Lock skip: {} try to create file", (Object)e.getMessage());
                this.createNewFileQuietly(file);
            }
            catch (IOException e) {
                throw new FileLockException(e.getMessage(), e);
            }
            catch (IllegalStateException e) {
                this.log.debug("openLock {}:{}", e.getClass(), (Object)e.getMessage());
            }
        }
        current = lockFiles.putIfAbsent(file, lock);
        if (current != null) {
            lock = current;
        }
        return lock;
    }

    private void closeQuietly(RandomAccessFile randomAccessFile) {
        if (randomAccessFile == null) {
            return;
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createNewFileQuietly(File file) {
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void release(Lock lock) throws FileLockException {
        if (lock == null) {
            this.log.debug("skip releasing null");
            return;
        }
        if (this.skipLocking) {
            return;
        }
        try {
            lockFiles.remove(lock.getFile());
            lock.close();
        }
        catch (ClosedChannelException e) {
            this.log.debug("ignore ClosedChannelException: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            throw new FileLockException(e.getMessage(), e);
        }
    }

    @Override
    public void clearLockFiles() {
        lockFiles.clear();
    }

    private boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (this.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isSkipLocking() {
        return this.skipLocking;
    }

    @Override
    public void setSkipLocking(boolean skipLocking) {
        this.skipLocking = skipLocking;
    }
}

