/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.bytecode;

import java.util.List;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;
import org.apache.maven.archiva.model.ArchivaArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeRecord
implements LuceneRepositoryContentRecord {
    private String repositoryId;
    private ArchivaArtifact artifact;
    private String filename;
    private List<String> classes;
    private List<String> methods;
    private List<String> files;

    public ArchivaArtifact getArtifact() {
        return this.artifact;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public String getPrimaryKey() {
        StringBuffer id = new StringBuffer();
        id.append(this.artifact.getGroupId()).append(":");
        id.append(this.artifact.getArtifactId()).append(":");
        id.append(this.artifact.getVersion());
        if (this.artifact.getClassifier() != null) {
            id.append(":").append(this.artifact.getClassifier());
        }
        id.append(":").append(this.artifact.getType());
        return id.toString();
    }

    public void setArtifact(ArchivaArtifact artifact) {
        this.artifact = artifact;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.artifact == null ? 0 : this.artifact.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BytecodeRecord other = (BytecodeRecord)obj;
        return !(this.artifact == null ? other.artifact != null : !this.artifact.equals((Object)other.artifact));
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("BytecodeRecord[");
        sb.append("artifact=").append(this.artifact);
        sb.append(",filename=").append(this.filename);
        sb.append("]");
        return sb.toString();
    }
}

