/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.functors;

import org.apache.commons.collections.Transformer;
import org.apache.maven.archiva.indexer.RepositoryIndexSearchException;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchableTransformer
implements Transformer {
    private Logger log = LoggerFactory.getLogger(SearchableTransformer.class);

    public Object transform(Object input) {
        if (input instanceof LuceneRepositoryContentIndex) {
            try {
                LuceneRepositoryContentIndex index = (LuceneRepositoryContentIndex)input;
                return index.getSearchable();
            }
            catch (RepositoryIndexSearchException e) {
                this.log.warn("Unable to get searchable for index:" + e.getMessage(), (Throwable)e);
            }
        }
        return input;
    }
}

