/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.hashcodes;

import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;
import org.apache.maven.archiva.model.ArchivaArtifact;

public class HashcodesRecord
implements LuceneRepositoryContentRecord {
    private String repositoryId;
    private ArchivaArtifact artifact;
    private String filename;

    public ArchivaArtifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ArchivaArtifact artifact) {
        this.artifact = artifact;
    }

    public String getPrimaryKey() {
        StringBuffer id = new StringBuffer();
        id.append(this.artifact.getGroupId()).append(":");
        id.append(this.artifact.getArtifactId()).append(":");
        id.append(this.artifact.getVersion());
        if (this.artifact.getClassifier() != null) {
            id.append(":").append(this.artifact.getClassifier());
        }
        id.append(":").append(this.artifact.getType());
        return id.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.artifact == null ? 0 : this.artifact.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashcodesRecord other = (HashcodesRecord)obj;
        return !(this.artifact == null ? other.artifact != null : !this.artifact.equals((Object)other.artifact));
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("HashcodesRecord[");
        sb.append("artifact=").append(this.artifact);
        sb.append(",filename=").append(this.filename);
        sb.append("]");
        return sb.toString();
    }
}

