/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.lucene;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;

public class LuceneDocumentMaker {
    public static final String PRIMARY_KEY = "pk";
    public static final String REPOSITORY_ID = "repoId";
    private Document document;

    public LuceneDocumentMaker(LuceneRepositoryContentRecord record) throws IllegalArgumentException {
        if (record == null) {
            throw new IllegalArgumentException("Not allowed to have a null record provider.");
        }
        String primaryKey = record.getPrimaryKey();
        if (StringUtils.isBlank((String)primaryKey)) {
            throw new IllegalArgumentException("Not allowed to have a blank primary key.");
        }
        String repositoryId = record.getRepositoryId();
        if (StringUtils.isBlank((String)repositoryId)) {
            throw new IllegalArgumentException("Not allowed to have a blank repository id.");
        }
        this.document = new Document();
        this.document.add((Fieldable)new Field(PRIMARY_KEY, primaryKey, Field.Store.NO, Field.Index.UN_TOKENIZED));
        this.document.add((Fieldable)new Field(REPOSITORY_ID, repositoryId, Field.Store.YES, Field.Index.UN_TOKENIZED));
    }

    public LuceneDocumentMaker addFieldTokenized(String key, String value) {
        if (value != null) {
            this.document.add((Fieldable)new Field(key, value, Field.Store.YES, Field.Index.TOKENIZED));
        }
        return this;
    }

    public LuceneDocumentMaker addFieldTokenized(String key, List list) {
        if (list != null && !list.isEmpty()) {
            return this.addFieldTokenized(key, StringUtils.join(list.iterator(), (String)"\n"));
        }
        return this;
    }

    public LuceneDocumentMaker addFieldUntokenized(String name, String value) {
        if (value != null) {
            this.document.add((Fieldable)new Field(name, value, Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        return this;
    }

    public LuceneDocumentMaker addFieldExact(String name, String value) {
        if (value != null) {
            this.document.add((Fieldable)new Field(name, value, Field.Store.NO, Field.Index.UN_TOKENIZED));
        }
        return this;
    }

    public Document getDocument() {
        return this.document;
    }
}

