/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.query;

import org.apache.maven.archiva.indexer.query.Query;
import org.apache.maven.archiva.indexer.query.QueryTerm;

public class RangeQuery
implements Query {
    private final boolean inclusive;
    private final QueryTerm begin;
    private final QueryTerm end;

    private RangeQuery(QueryTerm begin, QueryTerm end, boolean inclusive) {
        this.begin = begin;
        this.end = end;
        this.inclusive = inclusive;
    }

    public static RangeQuery createOpenRange() {
        return new RangeQuery(null, null, false);
    }

    public static RangeQuery createExclusiveRange(QueryTerm begin, QueryTerm end) {
        return new RangeQuery(begin, end, false);
    }

    public static RangeQuery createInclusiveRange(QueryTerm begin, QueryTerm end) {
        return new RangeQuery(begin, end, true);
    }

    public static RangeQuery createGreaterThanOrEqualToRange(QueryTerm begin) {
        return new RangeQuery(begin, null, true);
    }

    public static RangeQuery createGreaterThanRange(QueryTerm begin) {
        return new RangeQuery(begin, null, false);
    }

    public static RangeQuery createLessThanOrEqualToRange(QueryTerm end) {
        return new RangeQuery(null, end, true);
    }

    public static RangeQuery createLessThanRange(QueryTerm end) {
        return new RangeQuery(null, end, false);
    }

    public QueryTerm getBegin() {
        return this.begin;
    }

    public QueryTerm getEnd() {
        return this.end;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }
}

