/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.indexer.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.model.ArchivaArtifact;

public class SearchResultHit {
    private String context;
    private String url;
    private String groupId;
    private String artifactId;
    private String version = "";
    private String repositoryId = "";
    private List artifacts = new ArrayList();
    private List versions = new ArrayList();

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlFilename() {
        return this.url.substring(this.url.lastIndexOf(47));
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void addArtifact(ArchivaArtifact artifact) {
        this.artifacts.add(artifact);
        String ver = artifact.getVersion();
        if (!this.versions.contains(ver)) {
            this.versions.add(ver);
        }
        if (StringUtils.isBlank((String)this.groupId)) {
            this.groupId = artifact.getGroupId();
        }
        if (StringUtils.isBlank((String)this.artifactId)) {
            this.artifactId = artifact.getArtifactId();
        }
        if (StringUtils.isBlank((String)this.version)) {
            this.version = ver;
        }
    }

    public List getArtifacts() {
        return this.artifacts;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public List getVersions() {
        return this.versions;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }
}

