/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.indexer.search;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.archiva.indexer.search.RepositorySearch;
import org.apache.archiva.indexer.search.RepositorySearchException;
import org.apache.archiva.indexer.search.SearchFields;
import org.apache.archiva.indexer.search.SearchResultHit;
import org.apache.archiva.indexer.search.SearchResultLimits;
import org.apache.archiva.indexer.search.SearchResults;
import org.apache.archiva.indexer.util.SearchUtil;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.Configuration;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.FlatSearchRequest;
import org.sonatype.nexus.index.FlatSearchResponse;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusRepositorySearch
implements RepositorySearch {
    private static final Logger log = LoggerFactory.getLogger(NexusRepositorySearch.class);
    private NexusIndexer indexer;
    private ArchivaConfiguration archivaConfig;

    public NexusRepositorySearch(NexusIndexer indexer, ArchivaConfiguration archivaConfig) {
        this.indexer = indexer;
        this.archivaConfig = archivaConfig;
    }

    @Override
    public SearchResults search(String principal, List<String> selectedRepos, String term, SearchResultLimits limits, List<String> previousSearchTerms) throws RepositorySearchException {
        this.addIndexingContexts(selectedRepos);
        BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
        BooleanQuery q = new BooleanQuery();
        if (previousSearchTerms == null || previousSearchTerms.isEmpty()) {
            this.constructQuery(term, q);
        } else {
            for (String previousTerm : previousSearchTerms) {
                BooleanQuery iQuery = new BooleanQuery();
                this.constructQuery(previousTerm, iQuery);
                q.add((Query)iQuery, BooleanClause.Occur.MUST);
            }
            BooleanQuery iQuery = new BooleanQuery();
            this.constructQuery(term, iQuery);
            q.add((Query)iQuery, BooleanClause.Occur.MUST);
        }
        return this.search(limits, q);
    }

    @Override
    public SearchResults search(String principal, SearchFields searchFields, SearchResultLimits limits) throws RepositorySearchException {
        if (searchFields.getRepositories() == null) {
            throw new RepositorySearchException("Repositories cannot be null.");
        }
        this.addIndexingContexts(searchFields.getRepositories());
        BooleanQuery q = new BooleanQuery();
        if (searchFields.getGroupId() != null && !"".equals(searchFields.getGroupId())) {
            q.add(this.indexer.constructQuery("g", searchFields.getGroupId()), BooleanClause.Occur.MUST);
        }
        if (searchFields.getArtifactId() != null && !"".equals(searchFields.getArtifactId())) {
            q.add(this.indexer.constructQuery("a", searchFields.getArtifactId()), BooleanClause.Occur.MUST);
        }
        if (searchFields.getVersion() != null && !"".equals(searchFields.getVersion())) {
            q.add(this.indexer.constructQuery("v", searchFields.getVersion()), BooleanClause.Occur.MUST);
        }
        if (searchFields.getPackaging() != null && !"".equals(searchFields.getPackaging())) {
            q.add(this.indexer.constructQuery("p", searchFields.getPackaging()), BooleanClause.Occur.MUST);
        }
        if (searchFields.getClassName() != null && !"".equals(searchFields.getClassName())) {
            q.add(this.indexer.constructQuery("c", searchFields.getClassName()), BooleanClause.Occur.MUST);
        }
        if (q.getClauses() == null || q.getClauses().length <= 0) {
            throw new RepositorySearchException("No search fields set.");
        }
        return this.search(limits, q);
    }

    private SearchResults search(SearchResultLimits limits, BooleanQuery q) throws RepositorySearchException {
        try {
            FlatSearchRequest request = new FlatSearchRequest((Query)q);
            FlatSearchResponse response = this.indexer.searchFlat(request);
            if (response == null || response.getTotalHits() == 0) {
                SearchResults results = new SearchResults();
                results.setLimits(limits);
                SearchResults searchResults = results;
                return searchResults;
            }
            SearchResults searchResults = this.convertToSearchResults(response, limits);
            return searchResults;
        }
        catch (IOException e) {
            throw new RepositorySearchException(e);
        }
        finally {
            Map indexingContexts = this.indexer.getIndexingContexts();
            Set keys = indexingContexts.keySet();
            for (String key : keys) {
                try {
                    this.indexer.removeIndexingContext((IndexingContext)indexingContexts.get(key), false);
                    log.debug("Indexing context '" + key + "' removed from search.");
                }
                catch (IOException e) {
                    log.warn("IOException occurred while removing indexing content '" + key + "'.");
                }
            }
        }
    }

    private void constructQuery(String term, BooleanQuery q) {
        q.add(this.indexer.constructQuery("g", term), BooleanClause.Occur.SHOULD);
        q.add(this.indexer.constructQuery("a", term), BooleanClause.Occur.SHOULD);
        q.add(this.indexer.constructQuery("v", term), BooleanClause.Occur.SHOULD);
        q.add(this.indexer.constructQuery("p", term), BooleanClause.Occur.SHOULD);
        q.add(this.indexer.constructQuery("c", term), BooleanClause.Occur.SHOULD);
    }

    private void addIndexingContexts(List<String> selectedRepos) {
        for (String repo : selectedRepos) {
            try {
                Configuration config = this.archivaConfig.getConfiguration();
                ManagedRepositoryConfiguration repoConfig = config.findManagedRepositoryById(repo);
                if (repoConfig != null) {
                    String indexDir = repoConfig.getIndexDir();
                    File indexDirectory = null;
                    indexDirectory = indexDir != null && !"".equals(indexDir) ? new File(repoConfig.getIndexDir()) : new File(repoConfig.getLocation(), ".indexer");
                    IndexingContext context = this.indexer.addIndexingContext(repoConfig.getId(), repoConfig.getId(), new File(repoConfig.getLocation()), indexDirectory, null, null, NexusIndexer.FULL_INDEX);
                    context.setSearchable(repoConfig.isScanned());
                    continue;
                }
                log.warn("Repository '" + repo + "' not found in configuration.");
            }
            catch (UnsupportedExistingLuceneIndexException e) {
                log.warn("Error accessing index of repository '" + repo + "' : " + e.getMessage());
            }
            catch (IOException e) {
                log.warn("IO error occured while accessing index of repository '" + repo + "' : " + e.getMessage());
            }
        }
    }

    private SearchResults convertToSearchResults(FlatSearchResponse response, SearchResultLimits limits) {
        SearchResults results = new SearchResults();
        Set artifactInfos = response.getResults();
        for (ArtifactInfo artifactInfo : artifactInfos) {
            String id = SearchUtil.getHitId(artifactInfo.groupId, artifactInfo.artifactId);
            Map<String, SearchResultHit> hitsMap = results.getHitsMap();
            SearchResultHit hit = hitsMap.get(id);
            if (hit != null) {
                hit.addVersion(artifactInfo.version);
            } else {
                hit = new SearchResultHit();
                hit.setArtifactId(artifactInfo.artifactId);
                hit.setGroupId(artifactInfo.groupId);
                hit.setUrl(artifactInfo.repository + "/" + artifactInfo.fname);
                if (!hit.getVersions().contains(artifactInfo.version)) {
                    hit.addVersion(artifactInfo.version);
                }
            }
            results.addHit(id, hit);
        }
        results.setTotalHits(results.getHitsMap().size());
        results.setLimits(limits);
        if (limits == null || limits.getSelectedPage() == -1) {
            return results;
        }
        return this.paginate(results);
    }

    private SearchResults paginate(SearchResults results) {
        SearchResultLimits limits = results.getLimits();
        SearchResults paginated = new SearchResults();
        int fetchCount = limits.getPageSize();
        int offset = limits.getSelectedPage() * limits.getPageSize();
        if (fetchCount > results.getTotalHits()) {
            fetchCount = results.getTotalHits();
        }
        if (offset < results.getTotalHits()) {
            SearchResultHit hit;
            for (int i = 0; i < fetchCount && offset + i < results.getHits().size() && (hit = results.getHits().get(offset + i)) != null; ++i) {
                String id = SearchUtil.getHitId(hit.getGroupId(), hit.getArtifactId());
                paginated.addHit(id, hit);
            }
        }
        paginated.setTotalHits(results.getTotalHits());
        paginated.setLimits(limits);
        return paginated;
    }
}

