/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.indexer.merger;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.beans.RepositoryGroup;
import org.apache.archiva.indexer.merger.IndexMerger;
import org.apache.archiva.indexer.merger.IndexMergerRequest;
import org.apache.archiva.indexer.merger.MergedRemoteIndexesTask;
import org.apache.archiva.indexer.merger.MergedRemoteIndexesTaskRequest;
import org.apache.archiva.scheduler.MergedRemoteIndexesScheduler;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

@Service(value="mergedRemoteIndexesScheduler#default")
public class DefaultMergedRemoteIndexesScheduler
implements MergedRemoteIndexesScheduler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="taskScheduler#mergeRemoteIndexes")
    private TaskScheduler taskScheduler;
    @Inject
    private IndexMerger indexMerger;
    private Map<String, ScheduledFuture> scheduledFutureMap = new ConcurrentHashMap<String, ScheduledFuture>();

    public void schedule(RepositoryGroup repositoryGroup, File directory) {
        if (StringUtils.isEmpty((String)repositoryGroup.getCronExpression())) {
            return;
        }
        CronTrigger cronTrigger = new CronTrigger(repositoryGroup.getCronExpression());
        List repositories = repositoryGroup.getRepositories();
        IndexMergerRequest indexMergerRequest = new IndexMergerRequest(repositories, true, repositoryGroup.getId(), repositoryGroup.getMergedIndexPath(), repositoryGroup.getMergedIndexTtl()).mergedIndexDirectory(directory);
        MergedRemoteIndexesTaskRequest taskRequest = new MergedRemoteIndexesTaskRequest(indexMergerRequest, this.indexMerger);
        this.logger.info("schedule merge remote index for group {} with cron {}", (Object)repositoryGroup.getId(), (Object)repositoryGroup.getCronExpression());
        ScheduledFuture scheduledFuture = this.taskScheduler.schedule((Runnable)new MergedRemoteIndexesTask(taskRequest), (Trigger)cronTrigger);
        this.scheduledFutureMap.put(repositoryGroup.getId(), scheduledFuture);
    }

    public void unschedule(RepositoryGroup repositoryGroup) {
        ScheduledFuture scheduledFuture = this.scheduledFutureMap.remove(repositoryGroup.getId());
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
    }
}

