/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.indexer.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.beans.ProxyConnector;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.admin.model.proxyconnector.ProxyConnectorAdmin;
import org.apache.archiva.common.plexusbridge.MavenIndexerUtils;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.indexer.search.ArtifactInfoFilter;
import org.apache.archiva.indexer.search.NoClassifierArtifactInfoFilter;
import org.apache.archiva.indexer.search.RepositorySearch;
import org.apache.archiva.indexer.search.RepositorySearchException;
import org.apache.archiva.indexer.search.SearchFields;
import org.apache.archiva.indexer.search.SearchResultHit;
import org.apache.archiva.indexer.search.SearchResultLimits;
import org.apache.archiva.indexer.search.SearchResults;
import org.apache.archiva.indexer.util.SearchUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.OSGI;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.expr.UserInputSearchExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="repositorySearch#maven")
public class MavenRepositorySearch
implements RepositorySearch {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private NexusIndexer indexer;
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    private ProxyConnectorAdmin proxyConnectorAdmin;
    private MavenIndexerUtils mavenIndexerUtils;

    protected MavenRepositorySearch() {
    }

    @Inject
    public MavenRepositorySearch(PlexusSisuBridge plexusSisuBridge, ManagedRepositoryAdmin managedRepositoryAdmin, MavenIndexerUtils mavenIndexerUtils, ProxyConnectorAdmin proxyConnectorAdmin) throws PlexusSisuBridgeException {
        this.indexer = (NexusIndexer)plexusSisuBridge.lookup(NexusIndexer.class);
        this.managedRepositoryAdmin = managedRepositoryAdmin;
        this.mavenIndexerUtils = mavenIndexerUtils;
        this.proxyConnectorAdmin = proxyConnectorAdmin;
    }

    @Override
    public SearchResults search(String principal, List<String> selectedRepos, String term, SearchResultLimits limits, List<String> previousSearchTerms) throws RepositorySearchException {
        List<String> indexingContextIds = this.addIndexingContexts(selectedRepos);
        BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
        BooleanQuery q = new BooleanQuery();
        if (previousSearchTerms == null || previousSearchTerms.isEmpty()) {
            this.constructQuery(term, q);
        } else {
            for (String previousTerm : previousSearchTerms) {
                BooleanQuery iQuery = new BooleanQuery();
                this.constructQuery(previousTerm, iQuery);
                q.add((Query)iQuery, BooleanClause.Occur.MUST);
            }
            BooleanQuery iQuery = new BooleanQuery();
            this.constructQuery(term, iQuery);
            q.add((Query)iQuery, BooleanClause.Occur.MUST);
        }
        return this.search(limits, q, indexingContextIds, NoClassifierArtifactInfoFilter.LIST, selectedRepos, true);
    }

    @Override
    public SearchResults search(String principal, SearchFields searchFields, SearchResultLimits limits) throws RepositorySearchException {
        if (searchFields.getRepositories() == null) {
            throw new RepositorySearchException("Repositories cannot be null.");
        }
        List<String> indexingContextIds = this.addIndexingContexts(searchFields.getRepositories());
        if (!searchFields.getRepositories().isEmpty() && (indexingContextIds == null || indexingContextIds.isEmpty())) {
            return new SearchResults();
        }
        BooleanQuery q = new BooleanQuery();
        if (StringUtils.isNotBlank((String)searchFields.getGroupId())) {
            q.add(this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new UserInputSearchExpression(searchFields.getGroupId())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getArtifactId())) {
            q.add(this.indexer.constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new UserInputSearchExpression(searchFields.getArtifactId())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getVersion())) {
            q.add(this.indexer.constructQuery(MAVEN.VERSION, (SearchExpression)new SourcedSearchExpression(searchFields.getVersion())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getPackaging())) {
            q.add(this.indexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new UserInputSearchExpression(searchFields.getPackaging())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getClassName())) {
            q.add(this.indexer.constructQuery(MAVEN.CLASSNAMES, (SearchExpression)new UserInputSearchExpression(searchFields.getClassName())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getBundleSymbolicName())) {
            q.add(this.indexer.constructQuery(OSGI.SYMBOLIC_NAME, (SearchExpression)new UserInputSearchExpression(searchFields.getBundleSymbolicName())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getBundleVersion())) {
            q.add(this.indexer.constructQuery(OSGI.VERSION, (SearchExpression)new UserInputSearchExpression(searchFields.getBundleVersion())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getBundleExportPackage())) {
            q.add(this.indexer.constructQuery(OSGI.EXPORT_PACKAGE, (SearchExpression)new UserInputSearchExpression(searchFields.getBundleExportPackage())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getBundleExportService())) {
            q.add(this.indexer.constructQuery(OSGI.EXPORT_SERVICE, (SearchExpression)new UserInputSearchExpression(searchFields.getBundleExportService())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getBundleImportPackage())) {
            q.add(this.indexer.constructQuery(OSGI.IMPORT_PACKAGE, (SearchExpression)new UserInputSearchExpression(searchFields.getBundleImportPackage())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getBundleName())) {
            q.add(this.indexer.constructQuery(OSGI.NAME, (SearchExpression)new UserInputSearchExpression(searchFields.getBundleName())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getBundleImportPackage())) {
            q.add(this.indexer.constructQuery(OSGI.IMPORT_PACKAGE, (SearchExpression)new UserInputSearchExpression(searchFields.getBundleImportPackage())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getBundleRequireBundle())) {
            q.add(this.indexer.constructQuery(OSGI.REQUIRE_BUNDLE, (SearchExpression)new UserInputSearchExpression(searchFields.getBundleRequireBundle())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((String)searchFields.getClassifier())) {
            q.add(this.indexer.constructQuery(MAVEN.CLASSIFIER, (SearchExpression)new UserInputSearchExpression(searchFields.getClassifier())), BooleanClause.Occur.MUST);
        }
        if (q.getClauses() == null || q.getClauses().length <= 0) {
            throw new RepositorySearchException("No search fields set.");
        }
        return this.search(limits, q, indexingContextIds, Collections.emptyList(), searchFields.getRepositories(), searchFields.isIncludePomArtifacts());
    }

    private SearchResults search(SearchResultLimits limits, BooleanQuery q, List<String> indexingContextIds, List<? extends ArtifactInfoFilter> filters, List<String> selectedRepos, boolean includePoms) throws RepositorySearchException {
        try {
            FlatSearchRequest request = new FlatSearchRequest((Query)q);
            request.setContexts(this.getIndexingContexts(indexingContextIds));
            FlatSearchResponse response = this.indexer.searchFlat(request);
            if (response == null || response.getTotalHits() == 0) {
                SearchResults results = new SearchResults();
                results.setLimits(limits);
                return results;
            }
            return this.convertToSearchResults(response, limits, filters, selectedRepos, includePoms);
        }
        catch (IOException e) {
            throw new RepositorySearchException(e.getMessage(), e);
        }
        catch (RepositoryAdminException e) {
            throw new RepositorySearchException(e.getMessage(), e);
        }
    }

    private List<IndexingContext> getIndexingContexts(List<String> ids) {
        ArrayList<IndexingContext> contexts = new ArrayList<IndexingContext>(ids.size());
        for (String id : ids) {
            IndexingContext context = (IndexingContext)this.indexer.getIndexingContexts().get(id);
            if (context != null) {
                contexts.add(context);
                continue;
            }
            this.log.warn("context with id {} not exists", (Object)id);
        }
        return contexts;
    }

    private void constructQuery(String term, BooleanQuery q) {
        q.add(this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new UserInputSearchExpression(term)), BooleanClause.Occur.SHOULD);
        q.add(this.indexer.constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new UserInputSearchExpression(term)), BooleanClause.Occur.SHOULD);
        q.add(this.indexer.constructQuery(MAVEN.VERSION, (SearchExpression)new UserInputSearchExpression(term)), BooleanClause.Occur.SHOULD);
        q.add(this.indexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new UserInputSearchExpression(term)), BooleanClause.Occur.SHOULD);
        q.add(this.indexer.constructQuery(MAVEN.CLASSNAMES, (SearchExpression)new UserInputSearchExpression(term)), BooleanClause.Occur.SHOULD);
    }

    private List<String> addIndexingContexts(List<String> selectedRepos) {
        HashSet<String> indexingContextIds = new HashSet<String>();
        for (String repo : selectedRepos) {
            try {
                ManagedRepository repoConfig = this.managedRepositoryAdmin.getManagedRepository(repo);
                if (repoConfig != null) {
                    IndexingContext context = this.managedRepositoryAdmin.createIndexContext(repoConfig);
                    if (context.isSearchable()) {
                        indexingContextIds.addAll(this.getRemoteIndexingContextIds(repo));
                        indexingContextIds.add(context.getId());
                        continue;
                    }
                    this.log.warn("indexingContext with id {} not searchable", (Object)repoConfig.getId());
                    continue;
                }
                this.log.warn("Repository '{}' not found in configuration.", (Object)repo);
            }
            catch (RepositoryAdminException e) {
                this.log.warn("RepositoryAdminException occured while accessing index of repository '{}' : {}", (Object)repo, (Object)e.getMessage());
            }
        }
        return new ArrayList<String>(indexingContextIds);
    }

    @Override
    public Set<String> getRemoteIndexingContextIds(String managedRepoId) throws RepositoryAdminException {
        HashSet<String> ids = new HashSet<String>();
        List proxyConnectors = (List)this.proxyConnectorAdmin.getProxyConnectorAsMap().get(managedRepoId);
        if (proxyConnectors == null || proxyConnectors.isEmpty()) {
            return ids;
        }
        for (ProxyConnector proxyConnector : proxyConnectors) {
            String remoteId = "remote-" + proxyConnector.getTargetRepoId();
            IndexingContext context = (IndexingContext)this.indexer.getIndexingContexts().get(remoteId);
            if (context == null || !context.isSearchable()) continue;
            ids.add(remoteId);
        }
        return ids;
    }

    @Override
    public Collection<String> getAllGroupIds(String principal, List<String> selectedRepos) throws RepositorySearchException {
        List<IndexingContext> indexContexts = this.getIndexingContexts(selectedRepos);
        if (indexContexts == null || indexContexts.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            HashSet<String> allGroupIds = new HashSet<String>();
            for (IndexingContext indexingContext : indexContexts) {
                allGroupIds.addAll(indexingContext.getAllGroups());
            }
            return allGroupIds;
        }
        catch (IOException e) {
            throw new RepositorySearchException(e.getMessage(), e);
        }
    }

    protected List<? extends IndexCreator> getAllIndexCreators() {
        return this.mavenIndexerUtils.getAllIndexCreators();
    }

    private SearchResults convertToSearchResults(FlatSearchResponse response, SearchResultLimits limits, List<? extends ArtifactInfoFilter> artifactInfoFilters, List<String> selectedRepos, boolean includePoms) throws RepositoryAdminException {
        SearchResults results = new SearchResults();
        Set artifactInfos = response.getResults();
        for (ArtifactInfo artifactInfo : artifactInfos) {
            if (StringUtils.equalsIgnoreCase((String)"pom", (String)artifactInfo.fextension) && !includePoms) continue;
            String id = SearchUtil.getHitId(artifactInfo.groupId, artifactInfo.artifactId, artifactInfo.classifier, artifactInfo.packaging);
            Map<String, SearchResultHit> hitsMap = results.getHitsMap();
            if (!this.applyArtifactInfoFilters(artifactInfo, artifactInfoFilters, hitsMap)) continue;
            SearchResultHit hit = hitsMap.get(id);
            if (hit != null) {
                if (!hit.getVersions().contains(artifactInfo.version)) {
                    hit.addVersion(artifactInfo.version);
                }
            } else {
                hit = new SearchResultHit();
                hit.setArtifactId(artifactInfo.artifactId);
                hit.setGroupId(artifactInfo.groupId);
                hit.setRepositoryId(artifactInfo.repository);
                hit.addVersion(artifactInfo.version);
                hit.setBundleExportPackage(artifactInfo.bundleExportPackage);
                hit.setBundleExportService(artifactInfo.bundleExportService);
                hit.setBundleSymbolicName(artifactInfo.bundleSymbolicName);
                hit.setBundleVersion(artifactInfo.bundleVersion);
                hit.setBundleDescription(artifactInfo.bundleDescription);
                hit.setBundleDocUrl(artifactInfo.bundleDocUrl);
                hit.setBundleRequireBundle(artifactInfo.bundleRequireBundle);
                hit.setBundleImportPackage(artifactInfo.bundleImportPackage);
                hit.setBundleLicense(artifactInfo.bundleLicense);
                hit.setBundleName(artifactInfo.bundleName);
                hit.setContext(artifactInfo.context);
                hit.setGoals(artifactInfo.goals);
                hit.setPrefix(artifactInfo.prefix);
                hit.setPackaging(artifactInfo.packaging);
                hit.setClassifier(artifactInfo.classifier);
                hit.setFileExtension(artifactInfo.fextension);
                hit.setUrl(this.getBaseUrl(artifactInfo, selectedRepos));
            }
            results.addHit(id, hit);
        }
        results.setTotalHits(response.getTotalHitsCount());
        results.setTotalHitsMapSize(results.getHitsMap().values().size());
        results.setReturnedHitsCount(response.getReturnedHitsCount());
        results.setLimits(limits);
        if (limits == null || limits.getSelectedPage() == -1) {
            return results;
        }
        return this.paginate(results);
    }

    protected String getBaseUrl(ArtifactInfo artifactInfo, List<String> selectedRepos) throws RepositoryAdminException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.startsWith((String)artifactInfo.context, (String)"remote-")) {
            String managedRepoId = this.getManagedRepoId(StringUtils.substringAfter((String)artifactInfo.context, (String)"remote-"), selectedRepos);
            if (managedRepoId != null) {
                sb.append('/').append(managedRepoId);
                artifactInfo.context = managedRepoId;
            }
        } else {
            sb.append('/').append(artifactInfo.context);
        }
        sb.append('/').append(StringUtils.replaceChars((String)artifactInfo.groupId, (char)'.', (char)'/'));
        sb.append('/').append(artifactInfo.artifactId);
        sb.append('/').append(artifactInfo.version);
        sb.append('/').append(artifactInfo.artifactId);
        sb.append('-').append(artifactInfo.version);
        if (StringUtils.isNotBlank((String)artifactInfo.classifier)) {
            sb.append('-').append(artifactInfo.classifier);
        }
        if (StringUtils.equals((String)"maven-plugin", (String)artifactInfo.packaging)) {
            sb.append("jar");
        } else {
            sb.append('.').append(artifactInfo.packaging);
        }
        return sb.toString();
    }

    private String getManagedRepoId(String remoteRepo, List<String> selectedRepos) throws RepositoryAdminException {
        Map proxyConnectorMap = this.proxyConnectorAdmin.getProxyConnectorAsMap();
        if (proxyConnectorMap == null || proxyConnectorMap.isEmpty()) {
            return null;
        }
        if (selectedRepos != null && !selectedRepos.isEmpty()) {
            for (Map.Entry entry : proxyConnectorMap.entrySet()) {
                if (!selectedRepos.contains(entry.getKey())) continue;
                for (ProxyConnector proxyConnector : (List)entry.getValue()) {
                    if (!StringUtils.equals((String)remoteRepo, (String)proxyConnector.getTargetRepoId())) continue;
                    return proxyConnector.getSourceRepoId();
                }
            }
        }
        for (Map.Entry entry : proxyConnectorMap.entrySet()) {
            for (ProxyConnector proxyConnector : (List)entry.getValue()) {
                if (!StringUtils.equals((String)remoteRepo, (String)proxyConnector.getTargetRepoId())) continue;
                return proxyConnector.getSourceRepoId();
            }
        }
        return null;
    }

    private boolean applyArtifactInfoFilters(ArtifactInfo artifactInfo, List<? extends ArtifactInfoFilter> artifactInfoFilters, Map<String, SearchResultHit> currentResult) {
        if (artifactInfoFilters == null || artifactInfoFilters.isEmpty()) {
            return true;
        }
        for (ArtifactInfoFilter artifactInfoFilter : artifactInfoFilters) {
            if (artifactInfoFilter.addArtifactInResult(artifactInfo, currentResult)) continue;
            return false;
        }
        return true;
    }

    protected SearchResults paginate(SearchResults results) {
        SearchResultLimits limits = results.getLimits();
        SearchResults paginated = new SearchResults();
        int fetchCount = limits.getPageSize();
        int offset = limits.getSelectedPage() * limits.getPageSize();
        if (fetchCount > results.getTotalHits()) {
            fetchCount = results.getTotalHits();
        }
        if (offset < results.getTotalHits()) {
            SearchResultHit hit;
            for (int i = 0; i < fetchCount && offset + i < results.getHits().size() && (hit = results.getHits().get(offset + i)) != null; ++i) {
                String id = SearchUtil.getHitId(hit.getGroupId(), hit.getArtifactId(), hit.getClassifier(), hit.getPackaging());
                paginated.addHit(id, hit);
            }
        }
        paginated.setTotalHits(results.getTotalHits());
        paginated.setReturnedHitsCount(paginated.getHits().size());
        paginated.setTotalHitsMapSize(results.getTotalHitsMapSize());
        paginated.setLimits(limits);
        return paginated;
    }
}

