/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.ArtifactReference;
import org.apache.maven.archiva.model.CiManagement;
import org.apache.maven.archiva.model.Dependency;
import org.apache.maven.archiva.model.Exclusion;
import org.apache.maven.archiva.model.Individual;
import org.apache.maven.archiva.model.IssueManagement;
import org.apache.maven.archiva.model.License;
import org.apache.maven.archiva.model.MailingList;
import org.apache.maven.archiva.model.Organization;
import org.apache.maven.archiva.model.ProjectRepository;
import org.apache.maven.archiva.model.Scm;
import org.apache.maven.archiva.model.SnapshotVersion;
import org.apache.maven.archiva.model.VersionedReference;

public class ArchivaModelCloner {
    public static ArchivaProjectModel clone(ArchivaProjectModel model) {
        if (model == null) {
            return null;
        }
        ArchivaProjectModel cloned = new ArchivaProjectModel();
        cloned.setGroupId(model.getGroupId());
        cloned.setArtifactId(model.getArtifactId());
        cloned.setVersion(model.getVersion());
        cloned.setParentProject(ArchivaModelCloner.clone(model.getParentProject()));
        cloned.setName(model.getName());
        cloned.setDescription(model.getDescription());
        cloned.setUrl(model.getUrl());
        cloned.setPackaging(model.getPackaging());
        cloned.setOrigin(model.getOrigin());
        cloned.setMailingLists(ArchivaModelCloner.cloneMailingLists(model.getMailingLists()));
        cloned.setCiManagement(ArchivaModelCloner.clone(model.getCiManagement()));
        cloned.setIndividuals(ArchivaModelCloner.cloneIndividuals(model.getIndividuals()));
        cloned.setIssueManagement(ArchivaModelCloner.clone(model.getIssueManagement()));
        cloned.setLicenses(ArchivaModelCloner.cloneLicenses(model.getLicenses()));
        cloned.setOrganization(ArchivaModelCloner.clone(model.getOrganization()));
        cloned.setScm(ArchivaModelCloner.clone(model.getScm()));
        cloned.setRepositories(ArchivaModelCloner.cloneRepositories(model.getRepositories()));
        cloned.setDependencies(ArchivaModelCloner.cloneDependencies(model.getDependencies()));
        cloned.setPlugins(ArchivaModelCloner.clonePlugins(model.getPlugins()));
        cloned.setReports(ArchivaModelCloner.cloneReports(model.getReports()));
        cloned.setDependencyManagement(ArchivaModelCloner.cloneDependencies(model.getDependencyManagement()));
        return cloned;
    }

    public static ArtifactReference clone(ArtifactReference artifactReference) {
        if (artifactReference == null) {
            return null;
        }
        ArtifactReference cloned = new ArtifactReference();
        cloned.setGroupId(artifactReference.getGroupId());
        cloned.setArtifactId(artifactReference.getArtifactId());
        cloned.setVersion(artifactReference.getVersion());
        cloned.setClassifier(artifactReference.getClassifier());
        cloned.setType(artifactReference.getType());
        return cloned;
    }

    public static CiManagement clone(CiManagement ciManagement) {
        if (ciManagement == null) {
            return null;
        }
        CiManagement cloned = new CiManagement();
        cloned.setSystem(ciManagement.getSystem());
        cloned.setUrl(ciManagement.getUrl());
        return cloned;
    }

    public static Dependency clone(Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        Dependency cloned = new Dependency();
        cloned.setGroupId(dependency.getGroupId());
        cloned.setArtifactId(dependency.getArtifactId());
        cloned.setVersion(dependency.getVersion());
        cloned.setClassifier(dependency.getClassifier());
        cloned.setType(dependency.getType());
        cloned.setTransitive(dependency.isTransitive());
        cloned.setScope(dependency.getScope());
        cloned.setOptional(dependency.isOptional());
        cloned.setSystemPath(dependency.getSystemPath());
        cloned.setUrl(dependency.getUrl());
        cloned.setExclusions(ArchivaModelCloner.cloneExclusions(dependency.getExclusions()));
        return cloned;
    }

    public static IssueManagement clone(IssueManagement issueManagement) {
        if (issueManagement == null) {
            return null;
        }
        IssueManagement cloned = new IssueManagement();
        cloned.setSystem(issueManagement.getSystem());
        cloned.setUrl(issueManagement.getUrl());
        return cloned;
    }

    public static MailingList clone(MailingList mailingList) {
        if (mailingList == null) {
            return null;
        }
        MailingList cloned = new MailingList();
        cloned.setName(mailingList.getName());
        cloned.setSubscribeAddress(mailingList.getSubscribeAddress());
        cloned.setUnsubscribeAddress(mailingList.getUnsubscribeAddress());
        cloned.setPostAddress(mailingList.getPostAddress());
        cloned.setMainArchiveUrl(mailingList.getMainArchiveUrl());
        cloned.setOtherArchives(ArchivaModelCloner.cloneSimpleStringList(mailingList.getOtherArchives()));
        return cloned;
    }

    public static Organization clone(Organization organization) {
        if (organization == null) {
            return null;
        }
        Organization cloned = new Organization();
        cloned.setFavicon(organization.getFavicon());
        cloned.setName(organization.getName());
        cloned.setUrl(organization.getUrl());
        return cloned;
    }

    public static Properties clone(Properties properties) {
        if (properties == null) {
            return null;
        }
        Properties cloned = new Properties();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            cloned.setProperty(key, value);
        }
        return cloned;
    }

    public static Scm clone(Scm scm) {
        if (scm == null) {
            return null;
        }
        Scm cloned = new Scm();
        cloned.setConnection(scm.getConnection());
        cloned.setDeveloperConnection(scm.getDeveloperConnection());
        cloned.setUrl(scm.getUrl());
        return cloned;
    }

    public static SnapshotVersion clone(SnapshotVersion snapshotVersion) {
        if (snapshotVersion == null) {
            return null;
        }
        SnapshotVersion cloned = new SnapshotVersion();
        cloned.setTimestamp(snapshotVersion.getTimestamp());
        cloned.setBuildNumber(snapshotVersion.getBuildNumber());
        return cloned;
    }

    public static VersionedReference clone(VersionedReference versionedReference) {
        if (versionedReference == null) {
            return null;
        }
        VersionedReference cloned = new VersionedReference();
        cloned.setGroupId(versionedReference.getGroupId());
        cloned.setArtifactId(versionedReference.getArtifactId());
        cloned.setVersion(versionedReference.getVersion());
        return cloned;
    }

    public static List cloneArtifactReferences(List artifactReferenceList) {
        if (artifactReferenceList == null) {
            return null;
        }
        ArrayList<ArtifactReference> ret = new ArrayList<ArtifactReference>();
        for (ArtifactReference artifactReference : artifactReferenceList) {
            ret.add(ArchivaModelCloner.clone(artifactReference));
        }
        return ret;
    }

    public static List cloneDependencies(List dependencies) {
        if (dependencies == null) {
            return null;
        }
        ArrayList<Dependency> ret = new ArrayList<Dependency>();
        for (Dependency dep : dependencies) {
            if (dep == null) continue;
            ret.add(ArchivaModelCloner.clone(dep));
        }
        return ret;
    }

    public static List cloneExclusions(List exclusions) {
        if (exclusions == null) {
            return null;
        }
        ArrayList<Exclusion> ret = new ArrayList<Exclusion>();
        for (Exclusion exclusion : exclusions) {
            Exclusion cloned = new Exclusion();
            cloned.setGroupId(exclusion.getGroupId());
            cloned.setArtifactId(exclusion.getArtifactId());
            ret.add(cloned);
        }
        return ret;
    }

    public static List cloneIndividuals(List individuals) {
        if (individuals == null) {
            return individuals;
        }
        ArrayList<Individual> ret = new ArrayList<Individual>();
        for (Individual individual : individuals) {
            Individual cloned = new Individual();
            cloned.setPrincipal(individual.getPrincipal());
            cloned.setEmail(individual.getEmail());
            cloned.setName(individual.getName());
            cloned.setOrganization(individual.getOrganization());
            cloned.setOrganizationUrl(individual.getOrganizationUrl());
            cloned.setUrl(individual.getUrl());
            cloned.setTimezone(individual.getTimezone());
            cloned.setRoles(ArchivaModelCloner.cloneRoles(individual.getRoles()));
            cloned.setProperties(ArchivaModelCloner.clone(individual.getProperties()));
            ret.add(cloned);
        }
        return ret;
    }

    public static List cloneLicenses(List licenses) {
        if (licenses == null) {
            return null;
        }
        ArrayList<License> ret = new ArrayList<License>();
        for (License license : licenses) {
            License cloned = new License();
            cloned.setId(license.getId());
            cloned.setName(license.getName());
            cloned.setUrl(license.getUrl());
            cloned.setComments(license.getComments());
            ret.add(cloned);
        }
        return ret;
    }

    public static List cloneMailingLists(List mailingLists) {
        if (mailingLists == null) {
            return null;
        }
        ArrayList<MailingList> ret = new ArrayList<MailingList>();
        for (MailingList mailingList : mailingLists) {
            if (mailingList == null) continue;
            ret.add(ArchivaModelCloner.clone(mailingList));
        }
        return ret;
    }

    public static List clonePlugins(List plugins) {
        return ArchivaModelCloner.cloneArtifactReferences(plugins);
    }

    public static List cloneReports(List reports) {
        return ArchivaModelCloner.cloneArtifactReferences(reports);
    }

    public static List cloneRepositories(List repositories) {
        if (repositories == null) {
            return null;
        }
        ArrayList<ProjectRepository> ret = new ArrayList<ProjectRepository>();
        for (ProjectRepository repository : repositories) {
            ProjectRepository cloned = new ProjectRepository();
            cloned.setId(repository.getId());
            cloned.setName(repository.getName());
            cloned.setUrl(repository.getUrl());
            cloned.setLayout(repository.getLayout());
            cloned.setPlugins(repository.isPlugins());
            cloned.setReleases(repository.isReleases());
            cloned.setSnapshots(repository.isSnapshots());
            ret.add(cloned);
        }
        return ret;
    }

    public static List cloneRoles(List roles) {
        return ArchivaModelCloner.cloneSimpleStringList(roles);
    }

    private static List cloneSimpleStringList(List simple) {
        if (simple == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String txt : simple) {
            ret.add(txt);
        }
        return ret;
    }

    public static List cloneAvailableVersions(List availableVersions) {
        return ArchivaModelCloner.cloneSimpleStringList(availableVersions);
    }
}

