/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.model;

public class RepositoryURL {
    private String url;
    private String protocol;
    private String host;
    private String port;
    private String username;
    private String password;
    private String path;

    public RepositoryURL(String url) {
        this.url = url;
        int pos = url.indexOf(":/");
        if (pos == -1) {
            throw new IllegalArgumentException("Invalid URL, unable to parse protocol:// from " + url);
        }
        this.protocol = url.substring(0, pos);
        int postProtocolPos = this.protocol.length() + 1;
        while (url.charAt(postProtocolPos) == '/') {
            ++postProtocolPos;
        }
        if ("file".equals(this.protocol)) {
            this.path = "/" + url.substring(postProtocolPos);
            return;
        }
        pos = url.indexOf("/", postProtocolPos);
        if (pos == -1) {
            pos = url.length();
            this.path = "/";
        } else {
            this.path = url.substring(pos);
        }
        String middle = url.substring(postProtocolPos, pos);
        pos = middle.indexOf(64);
        if (pos > 0) {
            String authentication = middle.substring(0, pos);
            middle = middle.substring(pos + 1);
            pos = authentication.indexOf(58);
            if (pos > 0) {
                this.username = authentication.substring(0, pos);
                this.password = authentication.substring(pos + 1);
            } else {
                this.username = authentication;
            }
        }
        if ((pos = middle.indexOf(58)) > 0) {
            this.host = middle.substring(0, pos);
            this.port = middle.substring(pos + 1);
        } else {
            this.host = middle;
        }
    }

    public String toString() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUrl() {
        return this.url;
    }
}

