/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         This object is only used for the XML backup / restore
 * features of Archiva.
 *         This object is not serialized to the Database.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ArchivaAll
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field artifacts.
     */
    private java.util.List<ArchivaArtifactModel> artifacts;

    /**
     * Field repositoryMetadata.
     */
    private java.util.List<ArchivaRepositoryMetadata> repositoryMetadata;

    /**
     * Field projects.
     */
    private java.util.List<ArchivaProjectModel> projects;

    /**
     * Field repositoryProblems.
     */
    private java.util.List<RepositoryProblem> repositoryProblems;

    /**
     * Field repositoryContentStatistics.
     */
    private java.util.List<RepositoryContentStatistics> repositoryContentStatistics;

    /**
     * Field archivaAuditLogs.
     */
    private java.util.List<ArchivaAuditLogs> archivaAuditLogs;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addArchivaAuditLog.
     * 
     * @param archivaAuditLogs
     */
    public void addArchivaAuditLog( ArchivaAuditLogs archivaAuditLogs )
    {
        if ( !(archivaAuditLogs instanceof ArchivaAuditLogs) )
        {
            throw new ClassCastException( "ArchivaAll.addArchivaAuditLogs(archivaAuditLogs) parameter must be instanceof " + ArchivaAuditLogs.class.getName() );
        }
        getArchivaAuditLogs().add( archivaAuditLogs );
    } //-- void addArchivaAuditLog( ArchivaAuditLogs )

    /**
     * Method addArtifact.
     * 
     * @param archivaArtifactModel
     */
    public void addArtifact( ArchivaArtifactModel archivaArtifactModel )
    {
        if ( !(archivaArtifactModel instanceof ArchivaArtifactModel) )
        {
            throw new ClassCastException( "ArchivaAll.addArtifacts(archivaArtifactModel) parameter must be instanceof " + ArchivaArtifactModel.class.getName() );
        }
        getArtifacts().add( archivaArtifactModel );
    } //-- void addArtifact( ArchivaArtifactModel )

    /**
     * Method addProject.
     * 
     * @param archivaProjectModel
     */
    public void addProject( ArchivaProjectModel archivaProjectModel )
    {
        if ( !(archivaProjectModel instanceof ArchivaProjectModel) )
        {
            throw new ClassCastException( "ArchivaAll.addProjects(archivaProjectModel) parameter must be instanceof " + ArchivaProjectModel.class.getName() );
        }
        getProjects().add( archivaProjectModel );
    } //-- void addProject( ArchivaProjectModel )

    /**
     * Method addRepositoryContentStatistic.
     * 
     * @param repositoryContentStatistics
     */
    public void addRepositoryContentStatistic( RepositoryContentStatistics repositoryContentStatistics )
    {
        if ( !(repositoryContentStatistics instanceof RepositoryContentStatistics) )
        {
            throw new ClassCastException( "ArchivaAll.addRepositoryContentStatistics(repositoryContentStatistics) parameter must be instanceof " + RepositoryContentStatistics.class.getName() );
        }
        getRepositoryContentStatistics().add( repositoryContentStatistics );
    } //-- void addRepositoryContentStatistic( RepositoryContentStatistics )

    /**
     * Method addRepositoryMetadata.
     * 
     * @param archivaRepositoryMetadata
     */
    public void addRepositoryMetadata( ArchivaRepositoryMetadata archivaRepositoryMetadata )
    {
        if ( !(archivaRepositoryMetadata instanceof ArchivaRepositoryMetadata) )
        {
            throw new ClassCastException( "ArchivaAll.addRepositoryMetadata(archivaRepositoryMetadata) parameter must be instanceof " + ArchivaRepositoryMetadata.class.getName() );
        }
        getRepositoryMetadata().add( archivaRepositoryMetadata );
    } //-- void addRepositoryMetadata( ArchivaRepositoryMetadata )

    /**
     * Method addRepositoryProblem.
     * 
     * @param repositoryProblem
     */
    public void addRepositoryProblem( RepositoryProblem repositoryProblem )
    {
        if ( !(repositoryProblem instanceof RepositoryProblem) )
        {
            throw new ClassCastException( "ArchivaAll.addRepositoryProblems(repositoryProblem) parameter must be instanceof " + RepositoryProblem.class.getName() );
        }
        getRepositoryProblems().add( repositoryProblem );
    } //-- void addRepositoryProblem( RepositoryProblem )

    /**
     * Method getArchivaAuditLogs.
     * 
     * @return List
     */
    public java.util.List<ArchivaAuditLogs> getArchivaAuditLogs()
    {
        if ( this.archivaAuditLogs == null )
        {
            this.archivaAuditLogs = new java.util.ArrayList<ArchivaAuditLogs>();
        }

        return this.archivaAuditLogs;
    } //-- java.util.List<ArchivaAuditLogs> getArchivaAuditLogs()

    /**
     * Method getArtifacts.
     * 
     * @return List
     */
    public java.util.List<ArchivaArtifactModel> getArtifacts()
    {
        if ( this.artifacts == null )
        {
            this.artifacts = new java.util.ArrayList<ArchivaArtifactModel>();
        }

        return this.artifacts;
    } //-- java.util.List<ArchivaArtifactModel> getArtifacts()

    /**
     * Method getModelEncoding.
     * 
     * @return the current encoding used when reading/writing this
     * model
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Method getProjects.
     * 
     * @return List
     */
    public java.util.List<ArchivaProjectModel> getProjects()
    {
        if ( this.projects == null )
        {
            this.projects = new java.util.ArrayList<ArchivaProjectModel>();
        }

        return this.projects;
    } //-- java.util.List<ArchivaProjectModel> getProjects()

    /**
     * Method getRepositoryContentStatistics.
     * 
     * @return List
     */
    public java.util.List<RepositoryContentStatistics> getRepositoryContentStatistics()
    {
        if ( this.repositoryContentStatistics == null )
        {
            this.repositoryContentStatistics = new java.util.ArrayList<RepositoryContentStatistics>();
        }

        return this.repositoryContentStatistics;
    } //-- java.util.List<RepositoryContentStatistics> getRepositoryContentStatistics()

    /**
     * Method getRepositoryMetadata.
     * 
     * @return List
     */
    public java.util.List<ArchivaRepositoryMetadata> getRepositoryMetadata()
    {
        if ( this.repositoryMetadata == null )
        {
            this.repositoryMetadata = new java.util.ArrayList<ArchivaRepositoryMetadata>();
        }

        return this.repositoryMetadata;
    } //-- java.util.List<ArchivaRepositoryMetadata> getRepositoryMetadata()

    /**
     * Method getRepositoryProblems.
     * 
     * @return List
     */
    public java.util.List<RepositoryProblem> getRepositoryProblems()
    {
        if ( this.repositoryProblems == null )
        {
            this.repositoryProblems = new java.util.ArrayList<RepositoryProblem>();
        }

        return this.repositoryProblems;
    } //-- java.util.List<RepositoryProblem> getRepositoryProblems()

    /**
     * Method removeArchivaAuditLog.
     * 
     * @param archivaAuditLogs
     */
    public void removeArchivaAuditLog( ArchivaAuditLogs archivaAuditLogs )
    {
        if ( !(archivaAuditLogs instanceof ArchivaAuditLogs) )
        {
            throw new ClassCastException( "ArchivaAll.removeArchivaAuditLogs(archivaAuditLogs) parameter must be instanceof " + ArchivaAuditLogs.class.getName() );
        }
        getArchivaAuditLogs().remove( archivaAuditLogs );
    } //-- void removeArchivaAuditLog( ArchivaAuditLogs )

    /**
     * Method removeArtifact.
     * 
     * @param archivaArtifactModel
     */
    public void removeArtifact( ArchivaArtifactModel archivaArtifactModel )
    {
        if ( !(archivaArtifactModel instanceof ArchivaArtifactModel) )
        {
            throw new ClassCastException( "ArchivaAll.removeArtifacts(archivaArtifactModel) parameter must be instanceof " + ArchivaArtifactModel.class.getName() );
        }
        getArtifacts().remove( archivaArtifactModel );
    } //-- void removeArtifact( ArchivaArtifactModel )

    /**
     * Method removeProject.
     * 
     * @param archivaProjectModel
     */
    public void removeProject( ArchivaProjectModel archivaProjectModel )
    {
        if ( !(archivaProjectModel instanceof ArchivaProjectModel) )
        {
            throw new ClassCastException( "ArchivaAll.removeProjects(archivaProjectModel) parameter must be instanceof " + ArchivaProjectModel.class.getName() );
        }
        getProjects().remove( archivaProjectModel );
    } //-- void removeProject( ArchivaProjectModel )

    /**
     * Method removeRepositoryContentStatistic.
     * 
     * @param repositoryContentStatistics
     */
    public void removeRepositoryContentStatistic( RepositoryContentStatistics repositoryContentStatistics )
    {
        if ( !(repositoryContentStatistics instanceof RepositoryContentStatistics) )
        {
            throw new ClassCastException( "ArchivaAll.removeRepositoryContentStatistics(repositoryContentStatistics) parameter must be instanceof " + RepositoryContentStatistics.class.getName() );
        }
        getRepositoryContentStatistics().remove( repositoryContentStatistics );
    } //-- void removeRepositoryContentStatistic( RepositoryContentStatistics )

    /**
     * Method removeRepositoryMetadata.
     * 
     * @param archivaRepositoryMetadata
     */
    public void removeRepositoryMetadata( ArchivaRepositoryMetadata archivaRepositoryMetadata )
    {
        if ( !(archivaRepositoryMetadata instanceof ArchivaRepositoryMetadata) )
        {
            throw new ClassCastException( "ArchivaAll.removeRepositoryMetadata(archivaRepositoryMetadata) parameter must be instanceof " + ArchivaRepositoryMetadata.class.getName() );
        }
        getRepositoryMetadata().remove( archivaRepositoryMetadata );
    } //-- void removeRepositoryMetadata( ArchivaRepositoryMetadata )

    /**
     * Method removeRepositoryProblem.
     * 
     * @param repositoryProblem
     */
    public void removeRepositoryProblem( RepositoryProblem repositoryProblem )
    {
        if ( !(repositoryProblem instanceof RepositoryProblem) )
        {
            throw new ClassCastException( "ArchivaAll.removeRepositoryProblems(repositoryProblem) parameter must be instanceof " + RepositoryProblem.class.getName() );
        }
        getRepositoryProblems().remove( repositoryProblem );
    } //-- void removeRepositoryProblem( RepositoryProblem )

    /**
     * Set the archivaAuditLogs field.
     * 
     * @param archivaAuditLogs
     */
    public void setArchivaAuditLogs( java.util.List<ArchivaAuditLogs> archivaAuditLogs )
    {
        this.archivaAuditLogs = archivaAuditLogs;
    } //-- void setArchivaAuditLogs( java.util.List )

    /**
     * Set the artifacts field.
     * 
     * @param artifacts
     */
    public void setArtifacts( java.util.List<ArchivaArtifactModel> artifacts )
    {
        this.artifacts = artifacts;
    } //-- void setArtifacts( java.util.List )

    /**
     * Set an encoding used for reading/writing the model.
     * 
     * @param modelEncoding
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set the projects field.
     * 
     * @param projects
     */
    public void setProjects( java.util.List<ArchivaProjectModel> projects )
    {
        this.projects = projects;
    } //-- void setProjects( java.util.List )

    /**
     * Set the repositoryContentStatistics field.
     * 
     * @param repositoryContentStatistics
     */
    public void setRepositoryContentStatistics( java.util.List<RepositoryContentStatistics> repositoryContentStatistics )
    {
        this.repositoryContentStatistics = repositoryContentStatistics;
    } //-- void setRepositoryContentStatistics( java.util.List )

    /**
     * Set the repositoryMetadata field.
     * 
     * @param repositoryMetadata
     */
    public void setRepositoryMetadata( java.util.List<ArchivaRepositoryMetadata> repositoryMetadata )
    {
        this.repositoryMetadata = repositoryMetadata;
    } //-- void setRepositoryMetadata( java.util.List )

    /**
     * Set the repositoryProblems field.
     * 
     * @param repositoryProblems
     */
    public void setRepositoryProblems( java.util.List<RepositoryProblem> repositoryProblems )
    {
        this.repositoryProblems = repositoryProblems;
    } //-- void setRepositoryProblems( java.util.List )


    private static final long serialVersionUID = 3259707008803111764L;
          
}
