/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class ArchivaProjectModel.
 * 
 * @version $Revision$ $Date$
 */
public class ArchivaProjectModel
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The Group ID of the repository content.
     *           
     */
    private String groupId;

    /**
     * 
     *             The Artifact ID of the repository content.
     *           
     */
    private String artifactId;

    /**
     * 
     *             The version of the repository content.
     *           
     */
    private String version;

    /**
     * 
     *             The content key for a parent reference.
     *           
     */
    private VersionedReference parentProject;

    /**
     * 
     *             The declared packaging for this project model.
     *           
     */
    private String packaging;

    /**
     * 
     *             The name of this project.
     *           
     */
    private String name;

    /**
     * 
     *             The description of this project.
     *           
     */
    private String description;

    /**
     * 
     *             The Origin of this Model. (Filesystem, Proxy, or
     * Deploy)
     *           .
     */
    private String origin;

    /**
     * 
     *             The timestamp when this model was indexed.
     *           
     */
    private java.util.Date whenIndexed;

    /**
     * 
     *             The URL for the project's homepage.
     *           
     */
    private String url;

    /**
     * Field organization.
     */
    private Organization organization;

    /**
     * Field licenses.
     */
    private java.util.List<License> licenses;

    /**
     * Field mailingLists.
     */
    private java.util.List<MailingList> mailingLists;

    /**
     * The project's issue management system information.
     */
    private IssueManagement issueManagement;

    /**
     * The project's continuous integration information.
     */
    private CiManagement ciManagement;

    /**
     * 
     *             Specification for the SCM used by the project,
     * such as CVS, Subversion, etc.
     */
    private Scm scm;

    /**
     * Field individuals.
     */
    private java.util.List<Individual> individuals;

    /**
     * Field dependencies.
     */
    private java.util.List<Dependency> dependencies;

    /**
     * Field dependencyManagement.
     */
    private java.util.List<Dependency> dependencyManagement;

    /**
     * Field repositories.
     */
    private java.util.List<ProjectRepository> repositories;

    /**
     * Field plugins.
     */
    private java.util.List<ArtifactReference> plugins;

    /**
     * Field reports.
     */
    private java.util.List<ArtifactReference> reports;

    /**
     * Field buildExtensions.
     */
    private java.util.List<ArtifactReference> buildExtensions;

    /**
     * Field properties.
     */
    private java.util.Properties properties;

    /**
     * If relocated, this is the new location reference.
     */
    private VersionedReference relocation;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addBuildExtension.
     * 
     * @param artifactReference
     */
    public void addBuildExtension( ArtifactReference artifactReference )
    {
        if ( !(artifactReference instanceof ArtifactReference) )
        {
            throw new ClassCastException( "ArchivaProjectModel.addBuildExtensions(artifactReference) parameter must be instanceof " + ArtifactReference.class.getName() );
        }
        getBuildExtensions().add( artifactReference );
    } //-- void addBuildExtension( ArtifactReference )

    /**
     * Method addDependency.
     * 
     * @param dependency
     */
    public void addDependency( Dependency dependency )
    {
        if ( !(dependency instanceof Dependency) )
        {
            throw new ClassCastException( "ArchivaProjectModel.addDependencies(dependency) parameter must be instanceof " + Dependency.class.getName() );
        }
        getDependencies().add( dependency );
    } //-- void addDependency( Dependency )

    /**
     * Method addDependencyManagement.
     * 
     * @param dependency
     */
    public void addDependencyManagement( Dependency dependency )
    {
        if ( !(dependency instanceof Dependency) )
        {
            throw new ClassCastException( "ArchivaProjectModel.addDependencyManagement(dependency) parameter must be instanceof " + Dependency.class.getName() );
        }
        getDependencyManagement().add( dependency );
    } //-- void addDependencyManagement( Dependency )

    /**
     * Method addIndividual.
     * 
     * @param individual
     */
    public void addIndividual( Individual individual )
    {
        if ( !(individual instanceof Individual) )
        {
            throw new ClassCastException( "ArchivaProjectModel.addIndividuals(individual) parameter must be instanceof " + Individual.class.getName() );
        }
        getIndividuals().add( individual );
    } //-- void addIndividual( Individual )

    /**
     * Method addLicense.
     * 
     * @param license
     */
    public void addLicense( License license )
    {
        if ( !(license instanceof License) )
        {
            throw new ClassCastException( "ArchivaProjectModel.addLicenses(license) parameter must be instanceof " + License.class.getName() );
        }
        getLicenses().add( license );
    } //-- void addLicense( License )

    /**
     * Method addMailingList.
     * 
     * @param mailingList
     */
    public void addMailingList( MailingList mailingList )
    {
        if ( !(mailingList instanceof MailingList) )
        {
            throw new ClassCastException( "ArchivaProjectModel.addMailingLists(mailingList) parameter must be instanceof " + MailingList.class.getName() );
        }
        getMailingLists().add( mailingList );
    } //-- void addMailingList( MailingList )

    /**
     * Method addPlugin.
     * 
     * @param artifactReference
     */
    public void addPlugin( ArtifactReference artifactReference )
    {
        if ( !(artifactReference instanceof ArtifactReference) )
        {
            throw new ClassCastException( "ArchivaProjectModel.addPlugins(artifactReference) parameter must be instanceof " + ArtifactReference.class.getName() );
        }
        getPlugins().add( artifactReference );
    } //-- void addPlugin( ArtifactReference )

    /**
     * Method addProperty.
     * 
     * @param key
     * @param value
     */
    public void addProperty( String key, String value )
    {
        getProperties().put( key, value );
    } //-- void addProperty( String, String )

    /**
     * Method addReport.
     * 
     * @param artifactReference
     */
    public void addReport( ArtifactReference artifactReference )
    {
        if ( !(artifactReference instanceof ArtifactReference) )
        {
            throw new ClassCastException( "ArchivaProjectModel.addReports(artifactReference) parameter must be instanceof " + ArtifactReference.class.getName() );
        }
        getReports().add( artifactReference );
    } //-- void addReport( ArtifactReference )

    /**
     * Method addRepository.
     * 
     * @param projectRepository
     */
    public void addRepository( ProjectRepository projectRepository )
    {
        if ( !(projectRepository instanceof ProjectRepository) )
        {
            throw new ClassCastException( "ArchivaProjectModel.addRepositories(projectRepository) parameter must be instanceof " + ProjectRepository.class.getName() );
        }
        getRepositories().add( projectRepository );
    } //-- void addRepository( ProjectRepository )

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof ArchivaProjectModel ) )
        {
            return false;
        }

        ArchivaProjectModel that = (ArchivaProjectModel) other;
        boolean result = true;

        result = result && ( getGroupId() == null ? that.getGroupId() == null : getGroupId().equals( that.getGroupId() ) );
        result = result && ( getArtifactId() == null ? that.getArtifactId() == null : getArtifactId().equals( that.getArtifactId() ) );
        result = result && ( getVersion() == null ? that.getVersion() == null : getVersion().equals( that.getVersion() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get 
     *             The Artifact ID of the repository content.
     *           
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Method getBuildExtensions.
     * 
     * @return List
     */
    public java.util.List<ArtifactReference> getBuildExtensions()
    {
        if ( this.buildExtensions == null )
        {
            this.buildExtensions = new java.util.ArrayList<ArtifactReference>();
        }

        return this.buildExtensions;
    } //-- java.util.List<ArtifactReference> getBuildExtensions()

    /**
     * Get the project's continuous integration information.
     * 
     * @return CiManagement
     */
    public CiManagement getCiManagement()
    {
        return this.ciManagement;
    } //-- CiManagement getCiManagement()

    /**
     * Method getDependencies.
     * 
     * @return List
     */
    public java.util.List<Dependency> getDependencies()
    {
        if ( this.dependencies == null )
        {
            this.dependencies = new java.util.ArrayList<Dependency>();
        }

        return this.dependencies;
    } //-- java.util.List<Dependency> getDependencies()

    /**
     * Method getDependencyManagement.
     * 
     * @return List
     */
    public java.util.List<Dependency> getDependencyManagement()
    {
        if ( this.dependencyManagement == null )
        {
            this.dependencyManagement = new java.util.ArrayList<Dependency>();
        }

        return this.dependencyManagement;
    } //-- java.util.List<Dependency> getDependencyManagement()

    /**
     * Get 
     *             The description of this project.
     *           
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription()

    /**
     * Get 
     *             The Group ID of the repository content.
     *           
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * Method getIndividuals.
     * 
     * @return List
     */
    public java.util.List<Individual> getIndividuals()
    {
        if ( this.individuals == null )
        {
            this.individuals = new java.util.ArrayList<Individual>();
        }

        return this.individuals;
    } //-- java.util.List<Individual> getIndividuals()

    /**
     * Get the project's issue management system information.
     * 
     * @return IssueManagement
     */
    public IssueManagement getIssueManagement()
    {
        return this.issueManagement;
    } //-- IssueManagement getIssueManagement()

    /**
     * Method getLicenses.
     * 
     * @return List
     */
    public java.util.List<License> getLicenses()
    {
        if ( this.licenses == null )
        {
            this.licenses = new java.util.ArrayList<License>();
        }

        return this.licenses;
    } //-- java.util.List<License> getLicenses()

    /**
     * Method getMailingLists.
     * 
     * @return List
     */
    public java.util.List<MailingList> getMailingLists()
    {
        if ( this.mailingLists == null )
        {
            this.mailingLists = new java.util.ArrayList<MailingList>();
        }

        return this.mailingLists;
    } //-- java.util.List<MailingList> getMailingLists()

    /**
     * Get 
     *             The name of this project.
     *           
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Get the organization field.
     * 
     * @return Organization
     */
    public Organization getOrganization()
    {
        return this.organization;
    } //-- Organization getOrganization()

    /**
     * Get 
     *             The Origin of this Model. (Filesystem, Proxy, or
     * Deploy)
     *           .
     * 
     * @return String
     */
    public String getOrigin()
    {
        return this.origin;
    } //-- String getOrigin()

    /**
     * Get 
     *             The declared packaging for this project model.
     *           
     * 
     * @return String
     */
    public String getPackaging()
    {
        return this.packaging;
    } //-- String getPackaging()

    /**
     * Get 
     *             The content key for a parent reference.
     *           
     * 
     * @return VersionedReference
     */
    public VersionedReference getParentProject()
    {
        return this.parentProject;
    } //-- VersionedReference getParentProject()

    /**
     * Method getPlugins.
     * 
     * @return List
     */
    public java.util.List<ArtifactReference> getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList<ArtifactReference>();
        }

        return this.plugins;
    } //-- java.util.List<ArtifactReference> getPlugins()

    /**
     * Method getProperties.
     * 
     * @return Properties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }

        return this.properties;
    } //-- java.util.Properties getProperties()

    /**
     * Get if relocated, this is the new location reference.
     * 
     * @return VersionedReference
     */
    public VersionedReference getRelocation()
    {
        return this.relocation;
    } //-- VersionedReference getRelocation()

    /**
     * Method getReports.
     * 
     * @return List
     */
    public java.util.List<ArtifactReference> getReports()
    {
        if ( this.reports == null )
        {
            this.reports = new java.util.ArrayList<ArtifactReference>();
        }

        return this.reports;
    } //-- java.util.List<ArtifactReference> getReports()

    /**
     * Method getRepositories.
     * 
     * @return List
     */
    public java.util.List<ProjectRepository> getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList<ProjectRepository>();
        }

        return this.repositories;
    } //-- java.util.List<ProjectRepository> getRepositories()

    /**
     * Get 
     *             Specification for the SCM used by the project,
     * such as CVS, Subversion, etc.
     * 
     * @return Scm
     */
    public Scm getScm()
    {
        return this.scm;
    } //-- Scm getScm()

    /**
     * Get 
     *             The URL for the project's homepage.
     *           
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Get 
     *             The version of the repository content.
     *           
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Get 
     *             The timestamp when this model was indexed.
     *           
     * 
     * @return Date
     */
    public java.util.Date getWhenIndexed()
    {
        return this.whenIndexed;
    } //-- java.util.Date getWhenIndexed()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( groupId != null ? groupId.hashCode() : 0 );
        result = 37 * result + ( artifactId != null ? artifactId.hashCode() : 0 );
        result = 37 * result + ( version != null ? version.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Method removeBuildExtension.
     * 
     * @param artifactReference
     */
    public void removeBuildExtension( ArtifactReference artifactReference )
    {
        if ( !(artifactReference instanceof ArtifactReference) )
        {
            throw new ClassCastException( "ArchivaProjectModel.removeBuildExtensions(artifactReference) parameter must be instanceof " + ArtifactReference.class.getName() );
        }
        getBuildExtensions().remove( artifactReference );
    } //-- void removeBuildExtension( ArtifactReference )

    /**
     * Method removeDependency.
     * 
     * @param dependency
     */
    public void removeDependency( Dependency dependency )
    {
        if ( !(dependency instanceof Dependency) )
        {
            throw new ClassCastException( "ArchivaProjectModel.removeDependencies(dependency) parameter must be instanceof " + Dependency.class.getName() );
        }
        getDependencies().remove( dependency );
    } //-- void removeDependency( Dependency )

    /**
     * Method removeDependencyManagement.
     * 
     * @param dependency
     */
    public void removeDependencyManagement( Dependency dependency )
    {
        if ( !(dependency instanceof Dependency) )
        {
            throw new ClassCastException( "ArchivaProjectModel.removeDependencyManagement(dependency) parameter must be instanceof " + Dependency.class.getName() );
        }
        getDependencyManagement().remove( dependency );
    } //-- void removeDependencyManagement( Dependency )

    /**
     * Method removeIndividual.
     * 
     * @param individual
     */
    public void removeIndividual( Individual individual )
    {
        if ( !(individual instanceof Individual) )
        {
            throw new ClassCastException( "ArchivaProjectModel.removeIndividuals(individual) parameter must be instanceof " + Individual.class.getName() );
        }
        getIndividuals().remove( individual );
    } //-- void removeIndividual( Individual )

    /**
     * Method removeLicense.
     * 
     * @param license
     */
    public void removeLicense( License license )
    {
        if ( !(license instanceof License) )
        {
            throw new ClassCastException( "ArchivaProjectModel.removeLicenses(license) parameter must be instanceof " + License.class.getName() );
        }
        getLicenses().remove( license );
    } //-- void removeLicense( License )

    /**
     * Method removeMailingList.
     * 
     * @param mailingList
     */
    public void removeMailingList( MailingList mailingList )
    {
        if ( !(mailingList instanceof MailingList) )
        {
            throw new ClassCastException( "ArchivaProjectModel.removeMailingLists(mailingList) parameter must be instanceof " + MailingList.class.getName() );
        }
        getMailingLists().remove( mailingList );
    } //-- void removeMailingList( MailingList )

    /**
     * Method removePlugin.
     * 
     * @param artifactReference
     */
    public void removePlugin( ArtifactReference artifactReference )
    {
        if ( !(artifactReference instanceof ArtifactReference) )
        {
            throw new ClassCastException( "ArchivaProjectModel.removePlugins(artifactReference) parameter must be instanceof " + ArtifactReference.class.getName() );
        }
        getPlugins().remove( artifactReference );
    } //-- void removePlugin( ArtifactReference )

    /**
     * Method removeReport.
     * 
     * @param artifactReference
     */
    public void removeReport( ArtifactReference artifactReference )
    {
        if ( !(artifactReference instanceof ArtifactReference) )
        {
            throw new ClassCastException( "ArchivaProjectModel.removeReports(artifactReference) parameter must be instanceof " + ArtifactReference.class.getName() );
        }
        getReports().remove( artifactReference );
    } //-- void removeReport( ArtifactReference )

    /**
     * Method removeRepository.
     * 
     * @param projectRepository
     */
    public void removeRepository( ProjectRepository projectRepository )
    {
        if ( !(projectRepository instanceof ProjectRepository) )
        {
            throw new ClassCastException( "ArchivaProjectModel.removeRepositories(projectRepository) parameter must be instanceof " + ProjectRepository.class.getName() );
        }
        getRepositories().remove( projectRepository );
    } //-- void removeRepository( ProjectRepository )

    /**
     * Set 
     *             The Artifact ID of the repository content.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set 
     *             The list of build extensions that this project
     * uses.
     *           
     * 
     * @param buildExtensions
     */
    public void setBuildExtensions( java.util.List<ArtifactReference> buildExtensions )
    {
        this.buildExtensions = buildExtensions;
    } //-- void setBuildExtensions( java.util.List )

    /**
     * Set the project's continuous integration information.
     * 
     * @param ciManagement
     */
    public void setCiManagement( CiManagement ciManagement )
    {
        this.ciManagement = ciManagement;
    } //-- void setCiManagement( CiManagement )

    /**
     * Set 
     *               This element describes all of the dependencies
     * associated with a
     *               project.
     *           
     * 
     * @param dependencies
     */
    public void setDependencies( java.util.List<Dependency> dependencies )
    {
        this.dependencies = dependencies;
    } //-- void setDependencies( java.util.List )

    /**
     * Set 
     *             The list of dependency management settings.
     *           
     * 
     * @param dependencyManagement
     */
    public void setDependencyManagement( java.util.List<Dependency> dependencyManagement )
    {
        this.dependencyManagement = dependencyManagement;
    } //-- void setDependencyManagement( java.util.List )

    /**
     * Set 
     *             The description of this project.
     *           
     * 
     * @param description
     */
    public void setDescription( String description )
    {
        this.description = description;
    } //-- void setDescription( String )

    /**
     * Set 
     *             The Group ID of the repository content.
     *           
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )

    /**
     * Set 
     *             The list of individuals around this project.
     *           
     * 
     * @param individuals
     */
    public void setIndividuals( java.util.List<Individual> individuals )
    {
        this.individuals = individuals;
    } //-- void setIndividuals( java.util.List )

    /**
     * Set the project's issue management system information.
     * 
     * @param issueManagement
     */
    public void setIssueManagement( IssueManagement issueManagement )
    {
        this.issueManagement = issueManagement;
    } //-- void setIssueManagement( IssueManagement )

    /**
     * Set the licenses field.
     * 
     * @param licenses
     */
    public void setLicenses( java.util.List<License> licenses )
    {
        this.licenses = licenses;
    } //-- void setLicenses( java.util.List )

    /**
     * Set the mailing lists.
     * 
     * @param mailingLists
     */
    public void setMailingLists( java.util.List<MailingList> mailingLists )
    {
        this.mailingLists = mailingLists;
    } //-- void setMailingLists( java.util.List )

    /**
     * Set 
     *             The name of this project.
     *           
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set the organization field.
     * 
     * @param organization
     */
    public void setOrganization( Organization organization )
    {
        this.organization = organization;
    } //-- void setOrganization( Organization )

    /**
     * Set 
     *             The Origin of this Model. (Filesystem, Proxy, or
     * Deploy)
     *           .
     * 
     * @param origin
     */
    public void setOrigin( String origin )
    {
        this.origin = origin;
    } //-- void setOrigin( String )

    /**
     * Set 
     *             The declared packaging for this project model.
     *           
     * 
     * @param packaging
     */
    public void setPackaging( String packaging )
    {
        this.packaging = packaging;
    } //-- void setPackaging( String )

    /**
     * Set 
     *             The content key for a parent reference.
     *           
     * 
     * @param parentProject
     */
    public void setParentProject( VersionedReference parentProject )
    {
        this.parentProject = parentProject;
    } //-- void setParentProject( VersionedReference )

    /**
     * Set 
     *             The list of plugins that this project uses.
     *           
     * 
     * @param plugins
     */
    public void setPlugins( java.util.List<ArtifactReference> plugins )
    {
        this.plugins = plugins;
    } //-- void setPlugins( java.util.List )

    /**
     * Set 
     *             Properties on the project.  Only really used to
     * resolve
     *             variables inside of the project during an
     * effective project
     *             model resolution.
     *           
     * 
     * @param properties
     */
    public void setProperties( java.util.Properties properties )
    {
        this.properties = properties;
    } //-- void setProperties( java.util.Properties )

    /**
     * Set if relocated, this is the new location reference.
     * 
     * @param relocation
     */
    public void setRelocation( VersionedReference relocation )
    {
        this.relocation = relocation;
    } //-- void setRelocation( VersionedReference )

    /**
     * Set 
     *             The list of reports that this project uses.
     *           
     * 
     * @param reports
     */
    public void setReports( java.util.List<ArtifactReference> reports )
    {
        this.reports = reports;
    } //-- void setReports( java.util.List )

    /**
     * Set 
     *             The list project repositories in use by this
     * project.
     *           
     * 
     * @param repositories
     */
    public void setRepositories( java.util.List<ProjectRepository> repositories )
    {
        this.repositories = repositories;
    } //-- void setRepositories( java.util.List )

    /**
     * Set 
     *             Specification for the SCM used by the project,
     * such as CVS, Subversion, etc.
     * 
     * @param scm
     */
    public void setScm( Scm scm )
    {
        this.scm = scm;
    } //-- void setScm( Scm )

    /**
     * Set 
     *             The URL for the project's homepage.
     *           
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    /**
     * Set 
     *             The version of the repository content.
     *           
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )

    /**
     * Set 
     *             The timestamp when this model was indexed.
     *           
     * 
     * @param whenIndexed
     */
    public void setWhenIndexed( java.util.Date whenIndexed )
    {
        this.whenIndexed = whenIndexed;
    } //-- void setWhenIndexed( java.util.Date )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "groupId = '" );
        buf.append( getGroupId() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "artifactId = '" );
        buf.append( getArtifactId() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "version = '" );
        buf.append( getVersion() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


    private static final long serialVersionUID = -4216128775884469616L;
          
    public Dependency asDependency()
    {
        Dependency dep = new Dependency();
        
        dep.setGroupId( groupId );
        dep.setArtifactId( artifactId );
        dep.setVersion( version );
        dep.setType( packaging );
        
        return dep;
    }          
          
}
