/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class RepositoryProblem.
 * 
 * @version $Revision$ $Date$
 */
public class RepositoryProblem
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The repository associated with this path and
     * problem.
     *           
     */
    private String repositoryId;

    /**
     * 
     *             The path into the repository for the problem.
     *           
     */
    private String path;

    /**
     * 
     *             The Group ID of the repository content with the
     * problem.
     *           
     */
    private String groupId;

    /**
     * 
     *             The Artifact ID of the repository content with
     * the problem.
     *           
     */
    private String artifactId;

    /**
     * 
     *             The version of the repository content with the
     * problem.
     *           
     */
    private String version;

    /**
     * 
     *             The type of health problem.
     *           
     */
    private String type;

    /**
     * 
     *             The origin of the health problem.
     *           
     */
    private String origin;

    /**
     * 
     *             The origin of the health problem.
     *           
     */
    private String message;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The Artifact ID of the repository content with
     * the problem.
     *           
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Get 
     *             The Group ID of the repository content with the
     * problem.
     *           
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * Get 
     *             The origin of the health problem.
     *           
     * 
     * @return String
     */
    public String getMessage()
    {
        return this.message;
    } //-- String getMessage()

    /**
     * Get 
     *             The origin of the health problem.
     *           
     * 
     * @return String
     */
    public String getOrigin()
    {
        return this.origin;
    } //-- String getOrigin()

    /**
     * Get 
     *             The path into the repository for the problem.
     *           
     * 
     * @return String
     */
    public String getPath()
    {
        return this.path;
    } //-- String getPath()

    /**
     * Get 
     *             The repository associated with this path and
     * problem.
     *           
     * 
     * @return String
     */
    public String getRepositoryId()
    {
        return this.repositoryId;
    } //-- String getRepositoryId()

    /**
     * Get 
     *             The type of health problem.
     *           
     * 
     * @return String
     */
    public String getType()
    {
        return this.type;
    } //-- String getType()

    /**
     * Get 
     *             The version of the repository content with the
     * problem.
     *           
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Set 
     *             The Artifact ID of the repository content with
     * the problem.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set 
     *             The Group ID of the repository content with the
     * problem.
     *           
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )

    /**
     * Set 
     *             The origin of the health problem.
     *           
     * 
     * @param message
     */
    public void setMessage( String message )
    {
        this.message = message;
    } //-- void setMessage( String )

    /**
     * Set 
     *             The origin of the health problem.
     *           
     * 
     * @param origin
     */
    public void setOrigin( String origin )
    {
        this.origin = origin;
    } //-- void setOrigin( String )

    /**
     * Set 
     *             The path into the repository for the problem.
     *           
     * 
     * @param path
     */
    public void setPath( String path )
    {
        this.path = path;
    } //-- void setPath( String )

    /**
     * Set 
     *             The repository associated with this path and
     * problem.
     *           
     * 
     * @param repositoryId
     */
    public void setRepositoryId( String repositoryId )
    {
        this.repositoryId = repositoryId;
    } //-- void setRepositoryId( String )

    /**
     * Set 
     *             The type of health problem.
     *           
     * 
     * @param type
     */
    public void setType( String type )
    {
        this.type = type;
    } //-- void setType( String )

    /**
     * Set 
     *             The version of the repository content with the
     * problem.
     *           
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )


    private static final long serialVersionUID = -3426958367216659565L;
          
}
